/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.automaton.UTF32ToUTF8;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.AutomataMatchEvaluator;

public class AutomataMatch {
    private static final int MAX_LENGTH = 65536;

    public static EvalOperator.ExpressionEvaluator.Factory toEvaluator(Source source, EvalOperator.ExpressionEvaluator.Factory field, Automaton utf32Automaton) {
        Automaton automaton = Operations.determinize((Automaton)new UTF32ToUTF8().convert(utf32Automaton), (int)10000);
        ByteRunAutomaton run = new ByteRunAutomaton(automaton, true, 10000);
        return new AutomataMatchEvaluator.Factory(source, field, run, AutomataMatch.toDot(automaton));
    }

    static boolean process(BytesRef input, ByteRunAutomaton automaton, String pattern) {
        if (input == null) {
            return false;
        }
        return automaton.run(input.bytes, input.offset, input.length);
    }

    public static String toDot(Automaton automaton) {
        StringBuilder b = new StringBuilder();
        b.append("digraph Automaton {\n");
        b.append("  rankdir = LR\n");
        b.append("  node [width=0.2, height=0.2, fontsize=8]\n");
        int numStates = automaton.getNumStates();
        if (numStates > 0) {
            b.append("  initial [shape=plaintext,label=\"\"]\n");
            b.append("  initial -> 0\n");
        }
        Transition t = new Transition();
        block0: for (int state = 0; state < numStates; ++state) {
            b.append("  ");
            b.append(state);
            if (automaton.isAccept(state)) {
                b.append(" [shape=doublecircle,label=\"").append(state).append("\"]\n");
            } else {
                b.append(" [shape=circle,label=\"").append(state).append("\"]\n");
            }
            int numTransitions = automaton.initTransition(state, t);
            for (int i = 0; i < numTransitions; ++i) {
                automaton.getNextTransition(t);
                assert (t.max >= t.min);
                b.append("  ");
                b.append(state);
                b.append(" -> ");
                b.append(t.dest);
                b.append(" [label=\"");
                AutomataMatch.appendByte(t.min, b);
                if (t.max != t.min) {
                    b.append('-');
                    AutomataMatch.appendByte(t.max, b);
                }
                b.append("\"]\n");
                if (b.length() < 65536) continue;
                b.append("...snip...");
                break block0;
            }
        }
        b.append('}');
        return b.toString();
    }

    static void appendByte(int c, StringBuilder b) {
        if (c > 255) {
            throw new UnsupportedOperationException("can only format bytes but got [" + c + "]");
        }
        if (c == 34) {
            b.append("\\\"");
            return;
        }
        if (c == 92) {
            b.append("\\\\");
            return;
        }
        if (c >= 33 && c <= 126) {
            b.appendCodePoint(c);
            return;
        }
        b.append("0x");
        String hex = Integer.toHexString(c);
        switch (hex.length()) {
            case 1: {
                b.append('0').append(hex);
                break;
            }
            case 2: {
                b.append(hex);
                break;
            }
            default: {
                throw new UnsupportedOperationException("can only format bytes");
            }
        }
    }
}

