/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialIntersects;

public final class SpatialIntersectsGeoPointDocValuesAndSourceEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SpatialIntersectsGeoPointDocValuesAndSourceEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator left;
    private final EvalOperator.ExpressionEvaluator right;
    private final DriverContext driverContext;
    private Warnings warnings;

    public SpatialIntersectsGeoPointDocValuesAndSourceEvaluator(Source source, EvalOperator.ExpressionEvaluator left, EvalOperator.ExpressionEvaluator right, DriverContext driverContext) {
        this.source = source;
        this.left = left;
        this.right = right;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock leftBlock = (LongBlock)this.left.eval(page);){
            BooleanBlock booleanBlock;
            block12: {
                BytesRefBlock rightBlock = (BytesRefBlock)this.right.eval(page);
                try {
                    booleanBlock = this.eval(page.getPositionCount(), leftBlock, rightBlock);
                    if (rightBlock == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rightBlock != null) {
                        try {
                            rightBlock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rightBlock.close();
            }
            return booleanBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.left.baseRamBytesUsed();
        return baseRamBytesUsed += this.right.baseRamBytesUsed();
    }

    public BooleanBlock eval(int positionCount, LongBlock leftBlock, BytesRefBlock rightBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!leftBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (!rightBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                try {
                    SpatialIntersects.processGeoPointDocValuesAndSource(result, p, leftBlock, rightBlock);
                    continue;
                }
                catch (IOException | IllegalArgumentException e) {
                    this.warnings().registerException(e);
                    result.appendNull();
                }
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public String toString() {
        return "SpatialIntersectsGeoPointDocValuesAndSourceEvaluator[left=" + String.valueOf(this.left) + ", right=" + String.valueOf(this.right) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.left, this.right});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory left;
        private final EvalOperator.ExpressionEvaluator.Factory right;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory left, EvalOperator.ExpressionEvaluator.Factory right) {
            this.source = source;
            this.left = left;
            this.right = right;
        }

        public SpatialIntersectsGeoPointDocValuesAndSourceEvaluator get(DriverContext context) {
            return new SpatialIntersectsGeoPointDocValuesAndSourceEvaluator(this.source, this.left.get(context), this.right.get(context), context);
        }

        public String toString() {
            return "SpatialIntersectsGeoPointDocValuesAndSourceEvaluator[left=" + String.valueOf(this.left) + ", right=" + String.valueOf(this.right) + "]";
        }
    }
}

