/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateTrunc;

public final class DateTruncDateNanosEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DateTruncDateNanosEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator fieldVal;
    private final Rounding.Prepared rounding;
    private final DriverContext driverContext;
    private Warnings warnings;

    public DateTruncDateNanosEvaluator(Source source, EvalOperator.ExpressionEvaluator fieldVal, Rounding.Prepared rounding, DriverContext driverContext) {
        this.source = source;
        this.fieldVal = fieldVal;
        this.rounding = rounding;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock fieldValBlock = (LongBlock)this.fieldVal.eval(page);){
            LongVector fieldValVector = fieldValBlock.asVector();
            if (fieldValVector == null) {
                LongBlock longBlock = this.eval(page.getPositionCount(), fieldValBlock);
                return longBlock;
            }
            LongBlock longBlock = this.eval(page.getPositionCount(), fieldValVector).asBlock();
            return longBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.fieldVal.baseRamBytesUsed();
    }

    public LongBlock eval(int positionCount, LongBlock fieldValBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (fieldValBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (fieldValBlock.getValueCount(p) != 1) {
                    if (fieldValBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendLong(DateTrunc.processDateNanos(fieldValBlock.getLong(fieldValBlock.getFirstValueIndex(p)), this.rounding));
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongVector eval(int positionCount, LongVector fieldValVector) {
        try (LongVector.FixedBuilder result = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendLong(p, DateTrunc.processDateNanos(fieldValVector.getLong(p), this.rounding));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "DateTruncDateNanosEvaluator[fieldVal=" + String.valueOf(this.fieldVal) + ", rounding=" + String.valueOf(this.rounding) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.fieldVal);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory fieldVal;
        private final Rounding.Prepared rounding;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory fieldVal, Rounding.Prepared rounding) {
            this.source = source;
            this.fieldVal = fieldVal;
            this.rounding = rounding;
        }

        public DateTruncDateNanosEvaluator get(DriverContext context) {
            return new DateTruncDateNanosEvaluator(this.source, this.fieldVal.get(context), this.rounding, context);
        }

        public String toString() {
            return "DateTruncDateNanosEvaluator[fieldVal=" + String.valueOf(this.fieldVal) + ", rounding=" + String.valueOf(this.rounding) + "]";
        }
    }
}

