/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDouble;

public final class ToDoubleFromBooleanEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ToDoubleFromBooleanEvaluator.class);
    private final EvalOperator.ExpressionEvaluator bool;

    public ToDoubleFromBooleanEvaluator(Source source, EvalOperator.ExpressionEvaluator bool, DriverContext driverContext) {
        super(driverContext, source);
        this.bool = bool;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.bool;
    }

    @Override
    public Block evalVector(Vector v) {
        BooleanVector vector = (BooleanVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            return this.driverContext.blockFactory().newConstantDoubleBlockWith(this.evalValue(vector, 0), positionCount);
        }
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendDouble(this.evalValue(vector, p));
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    private double evalValue(BooleanVector container, int index) {
        boolean value = container.getBoolean(index);
        return ToDouble.fromBoolean(value);
    }

    @Override
    public Block evalBlock(Block b) {
        BooleanBlock block = (BooleanBlock)b;
        int positionCount = block.getPositionCount();
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    double value = this.evalValue(block, i);
                    if (!positionOpened && valueCount > 1) {
                        builder.beginPositionEntry();
                        positionOpened = true;
                    }
                    builder.appendDouble(value);
                    valuesAppended = true;
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    private double evalValue(BooleanBlock container, int index) {
        boolean value = container.getBoolean(index);
        return ToDouble.fromBoolean(value);
    }

    public String toString() {
        return "ToDoubleFromBooleanEvaluator[bool=" + String.valueOf(this.bool) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.bool);
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.bool.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory bool;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory bool) {
            this.source = source;
            this.bool = bool;
        }

        public ToDoubleFromBooleanEvaluator get(DriverContext context) {
            return new ToDoubleFromBooleanEvaluator(this.source, this.bool.get(context), context);
        }

        public String toString() {
            return "ToDoubleFromBooleanEvaluator[bool=" + String.valueOf(this.bool) + "]";
        }
    }
}

