/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.voyageai.embeddings;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.voyageai.VoyageAIServiceSettings;
import org.elasticsearch.xpack.inference.services.voyageai.embeddings.VoyageAIEmbeddingType;

public class VoyageAIEmbeddingsServiceSettings
extends FilteredXContentObject
implements ServiceSettings {
    public static final String NAME = "voyageai_embeddings_service_settings";
    static final String DIMENSIONS_SET_BY_USER = "dimensions_set_by_user";
    public static final VoyageAIEmbeddingsServiceSettings EMPTY_SETTINGS = new VoyageAIEmbeddingsServiceSettings(null, null, null, null, null, false);
    public static final String EMBEDDING_TYPE = "embedding_type";
    private static final TransportVersion VOYAGE_AI_INTEGRATION_ADDED = TransportVersion.fromName((String)"voyage_ai_integration_added");
    private final VoyageAIServiceSettings commonSettings;
    private final VoyageAIEmbeddingType embeddingType;
    private final SimilarityMeasure similarity;
    private final Integer dimensions;
    private final Integer maxInputTokens;
    private final boolean dimensionsSetByUser;

    public static VoyageAIEmbeddingsServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigurationParseContext.REQUEST -> VoyageAIEmbeddingsServiceSettings.fromRequestMap(map, context);
            case ConfigurationParseContext.PERSISTENT -> VoyageAIEmbeddingsServiceSettings.fromPersistentMap(map, context);
        };
    }

    private static VoyageAIEmbeddingsServiceSettings fromRequestMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        VoyageAIServiceSettings commonServiceSettings = VoyageAIServiceSettings.fromMap(map, context);
        VoyageAIEmbeddingType embeddingTypes = VoyageAIEmbeddingsServiceSettings.parseEmbeddingType(map, context, validationException);
        SimilarityMeasure similarity = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        Integer dims = ServiceUtils.removeAsType(map, "dimensions", Integer.class);
        Integer maxInputTokens = ServiceUtils.removeAsType(map, "max_input_tokens", Integer.class);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new VoyageAIEmbeddingsServiceSettings(commonServiceSettings, embeddingTypes, similarity, dims, maxInputTokens, dims != null);
    }

    private static VoyageAIEmbeddingsServiceSettings fromPersistentMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        VoyageAIServiceSettings commonServiceSettings = VoyageAIServiceSettings.fromMap(map, context);
        VoyageAIEmbeddingType embeddingTypes = VoyageAIEmbeddingsServiceSettings.parseEmbeddingType(map, context, validationException);
        SimilarityMeasure similarity = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        Integer dims = ServiceUtils.removeAsType(map, "dimensions", Integer.class);
        Integer maxInputTokens = ServiceUtils.removeAsType(map, "max_input_tokens", Integer.class);
        Boolean dimensionsSetByUser = ServiceUtils.removeAsType(map, DIMENSIONS_SET_BY_USER, Boolean.class);
        if (dimensionsSetByUser == null) {
            dimensionsSetByUser = Boolean.FALSE;
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new VoyageAIEmbeddingsServiceSettings(commonServiceSettings, embeddingTypes, similarity, dims, maxInputTokens, dimensionsSetByUser);
    }

    static VoyageAIEmbeddingType parseEmbeddingType(Map<String, Object> map, ConfigurationParseContext context, ValidationException validationException) {
        switch (context) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case REQUEST: 
            case PERSISTENT: 
        }
        return Objects.requireNonNullElse(ServiceUtils.extractOptionalEnum(map, EMBEDDING_TYPE, "service_settings", VoyageAIEmbeddingType::fromString, EnumSet.allOf(VoyageAIEmbeddingType.class), validationException), VoyageAIEmbeddingType.FLOAT);
    }

    public VoyageAIEmbeddingsServiceSettings(VoyageAIServiceSettings commonSettings, @Nullable VoyageAIEmbeddingType embeddingType, @Nullable SimilarityMeasure similarity, @Nullable Integer dimensions, @Nullable Integer maxInputTokens, boolean dimensionsSetByUser) {
        this.commonSettings = commonSettings;
        this.similarity = similarity;
        this.dimensions = dimensions;
        this.maxInputTokens = maxInputTokens;
        this.embeddingType = embeddingType;
        this.dimensionsSetByUser = dimensionsSetByUser;
    }

    public VoyageAIEmbeddingsServiceSettings(StreamInput in) throws IOException {
        this.commonSettings = new VoyageAIServiceSettings(in);
        this.similarity = (SimilarityMeasure)in.readOptionalEnum(SimilarityMeasure.class);
        this.dimensions = in.readOptionalVInt();
        this.maxInputTokens = in.readOptionalVInt();
        this.embeddingType = Objects.requireNonNullElse((VoyageAIEmbeddingType)in.readOptionalEnum(VoyageAIEmbeddingType.class), VoyageAIEmbeddingType.FLOAT);
        this.dimensionsSetByUser = in.readBoolean();
    }

    public VoyageAIServiceSettings getCommonSettings() {
        return this.commonSettings;
    }

    public SimilarityMeasure similarity() {
        return this.similarity;
    }

    public Integer dimensions() {
        return this.dimensions;
    }

    public Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    public String modelId() {
        return this.commonSettings.modelId();
    }

    public VoyageAIEmbeddingType getEmbeddingType() {
        return this.embeddingType;
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return this.embeddingType == null ? DenseVectorFieldMapper.ElementType.FLOAT : this.embeddingType.toElementType();
    }

    public Boolean dimensionsSetByUser() {
        return this.dimensionsSetByUser;
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder = this.commonSettings.toXContentFragment(builder, params);
        if (this.similarity != null) {
            builder.field("similarity", (Enum)this.similarity);
        }
        if (this.dimensions != null) {
            builder.field("dimensions", this.dimensions);
        }
        if (this.maxInputTokens != null) {
            builder.field("max_input_tokens", this.maxInputTokens);
        }
        if (this.embeddingType != null) {
            builder.field(EMBEDDING_TYPE, (Enum)this.embeddingType);
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.commonSettings.toXContentFragmentOfExposedFields(builder, params);
        return builder;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return VOYAGE_AI_INTEGRATION_ADDED;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.commonSettings.writeTo(out);
        out.writeOptionalEnum((Enum)SimilarityMeasure.translateSimilarity((SimilarityMeasure)this.similarity, (TransportVersion)out.getTransportVersion()));
        out.writeOptionalVInt(this.dimensions);
        out.writeOptionalVInt(this.maxInputTokens);
        out.writeOptionalEnum((Enum)this.embeddingType);
        out.writeBoolean(this.dimensionsSetByUser);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoyageAIEmbeddingsServiceSettings that = (VoyageAIEmbeddingsServiceSettings)o;
        return Objects.equals(this.commonSettings, that.commonSettings) && Objects.equals(this.similarity, that.similarity) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.maxInputTokens, that.maxInputTokens) && Objects.equals((Object)this.embeddingType, (Object)that.embeddingType) && Objects.equals(this.dimensionsSetByUser, that.dimensionsSetByUser);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.commonSettings, this.similarity, this.dimensions, this.maxInputTokens, this.embeddingType, this.dimensionsSetByUser});
    }
}

