/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.ibmwatsonx.response;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;

public class IbmWatsonxErrorResponseEntity
extends ErrorResponse {
    private IbmWatsonxErrorResponseEntity(String errorMessage) {
        super(errorMessage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ErrorResponse fromResponse(HttpResult response) {
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response.body());){
            Map responseMap = jsonParser.map();
            Map error = (Map)responseMap.get("error");
            if (error == null) return ErrorResponse.UNDEFINED_ERROR;
            String message = (String)error.get("message");
            IbmWatsonxErrorResponseEntity ibmWatsonxErrorResponseEntity = new IbmWatsonxErrorResponseEntity(Objects.requireNonNullElse(message, ""));
            return ibmWatsonxErrorResponseEntity;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ErrorResponse.UNDEFINED_ERROR;
    }
}

