/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface.response;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingFloatResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;

public class HuggingFaceEmbeddingsResponseEntity {
    private static final String FAILED_TO_FIND_FIELD_TEMPLATE = "Failed to find required field [%s] in Hugging Face embeddings response";

    public static TextEmbeddingFloatResults fromResponse(Request request, HttpResult response) throws IOException {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, response.body());){
            XContentUtils.moveToFirstToken(jsonParser);
            XContentParser.Token token = jsonParser.currentToken();
            if (token == XContentParser.Token.START_ARRAY) {
                TextEmbeddingFloatResults textEmbeddingFloatResults = HuggingFaceEmbeddingsResponseEntity.parseArrayFormat(jsonParser);
                return textEmbeddingFloatResults;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                TextEmbeddingFloatResults textEmbeddingFloatResults = HuggingFaceEmbeddingsResponseEntity.parseObjectFormat(jsonParser);
                return textEmbeddingFloatResults;
            }
            XContentParserUtils.throwUnknownToken((XContentParser.Token)token, (XContentParser)jsonParser);
        }
        throw new IllegalStateException("Reached an invalid state while parsing the hugging face response");
    }

    private static TextEmbeddingFloatResults parseArrayFormat(XContentParser parser) throws IOException {
        List embeddingList = XContentParserUtils.parseList((XContentParser)parser, HuggingFaceEmbeddingsResponseEntity::parseEmbeddingEntry);
        return new TextEmbeddingFloatResults(embeddingList);
    }

    private static TextEmbeddingFloatResults parseObjectFormat(XContentParser parser) throws IOException {
        XContentUtils.positionParserAtTokenAfterField(parser, "embeddings", FAILED_TO_FIND_FIELD_TEMPLATE);
        List embeddingList = XContentParserUtils.parseList((XContentParser)parser, HuggingFaceEmbeddingsResponseEntity::parseEmbeddingEntry);
        return new TextEmbeddingFloatResults(embeddingList);
    }

    private static TextEmbeddingFloatResults.Embedding parseEmbeddingEntry(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        List embeddingValuesList = XContentParserUtils.parseList((XContentParser)parser, XContentUtils::parseFloat);
        return TextEmbeddingFloatResults.Embedding.of((List)embeddingValuesList);
    }

    private HuggingFaceEmbeddingsResponseEntity() {
    }
}

