/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface.request.rerank;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.huggingface.rerank.HuggingFaceRerankTaskSettings;

public record HuggingFaceRerankRequestEntity(String query, List<String> documents, @Nullable Boolean returnDocuments, @Nullable Integer topN, HuggingFaceRerankTaskSettings taskSettings) implements ToXContentObject
{
    private static final String RETURN_TEXT = "return_text";
    private static final String DOCUMENTS_FIELD = "texts";
    private static final String QUERY_FIELD = "query";

    public HuggingFaceRerankRequestEntity {
        Objects.requireNonNull(query);
        Objects.requireNonNull(documents);
        Objects.requireNonNull(taskSettings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DOCUMENTS_FIELD, this.documents);
        builder.field(QUERY_FIELD, this.query);
        if (this.returnDocuments != null) {
            builder.field(RETURN_TEXT, this.returnDocuments);
        } else if (this.taskSettings.getReturnDocuments() != null) {
            builder.field(RETURN_TEXT, this.taskSettings.getReturnDocuments());
        }
        if (this.topN != null) {
            builder.field("top_n", this.topN);
        } else if (this.taskSettings.getTopNDocumentsOnly() != null) {
            builder.field("top_n", this.taskSettings.getTopNDocumentsOnly());
        }
        builder.endObject();
        return builder;
    }
}

