/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface;

import java.util.Locale;
import java.util.Optional;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.UnifiedChatCompletionException;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.huggingface.response.HuggingFaceErrorResponseEntity;
import org.elasticsearch.xpack.inference.services.openai.OpenAiUnifiedChatCompletionResponseHandler;

public class HuggingFaceChatCompletionResponseHandler
extends OpenAiUnifiedChatCompletionResponseHandler {
    private static final String HUGGING_FACE_ERROR = "hugging_face_error";

    public HuggingFaceChatCompletionResponseHandler(String requestType, ResponseParser parseFunction) {
        super(requestType, parseFunction, HuggingFaceErrorResponseEntity::fromResponse);
    }

    @Override
    protected Exception buildError(String message, Request request, HttpResult result, ErrorResponse errorResponse) {
        assert (request.isStreaming()) : "Only streaming requests support this format";
        int responseStatusCode = result.response().getStatusLine().getStatusCode();
        if (request.isStreaming()) {
            String errorMessage = this.errorMessage(message, request, result, errorResponse, responseStatusCode);
            RestStatus restStatus = HuggingFaceChatCompletionResponseHandler.toRestStatus(responseStatusCode);
            return errorResponse instanceof HuggingFaceErrorResponseEntity ? new UnifiedChatCompletionException(restStatus, errorMessage, HUGGING_FACE_ERROR, restStatus.name().toLowerCase(Locale.ROOT)) : new UnifiedChatCompletionException(restStatus, errorMessage, HuggingFaceChatCompletionResponseHandler.createErrorType(errorResponse), restStatus.name().toLowerCase(Locale.ROOT));
        }
        return super.buildError(message, request, result, errorResponse);
    }

    @Override
    protected Exception buildMidStreamError(Request request, String message, Exception e) {
        ErrorResponse errorResponse = StreamingHuggingFaceErrorResponseEntity.fromString(message);
        if (errorResponse instanceof StreamingHuggingFaceErrorResponseEntity) {
            StreamingHuggingFaceErrorResponseEntity streamingHuggingFaceErrorResponseEntity = (StreamingHuggingFaceErrorResponseEntity)errorResponse;
            return new UnifiedChatCompletionException(RestStatus.INTERNAL_SERVER_ERROR, Strings.format((String)"%s for request from inference entity id [%s]. Error message: [%s]", (Object[])new Object[]{"Received an error response", request.getInferenceEntityId(), errorResponse.getErrorMessage()}), HUGGING_FACE_ERROR, HuggingFaceChatCompletionResponseHandler.extractErrorCode(streamingHuggingFaceErrorResponseEntity));
        }
        if (e != null) {
            return UnifiedChatCompletionException.fromThrowable((Throwable)e);
        }
        return new UnifiedChatCompletionException(RestStatus.INTERNAL_SERVER_ERROR, Strings.format((String)"%s for request from inference entity id [%s]", (Object[])new Object[]{"Received an error response", request.getInferenceEntityId()}), HuggingFaceChatCompletionResponseHandler.createErrorType(errorResponse), "stream_error");
    }

    private static String extractErrorCode(StreamingHuggingFaceErrorResponseEntity streamingHuggingFaceErrorResponseEntity) {
        return streamingHuggingFaceErrorResponseEntity.httpStatusCode() != null ? String.valueOf(streamingHuggingFaceErrorResponseEntity.httpStatusCode()) : null;
    }

    private static class StreamingHuggingFaceErrorResponseEntity
    extends ErrorResponse {
        private static final ConstructingObjectParser<Optional<ErrorResponse>, Void> ERROR_PARSER = new ConstructingObjectParser("hugging_face_error", true, args -> Optional.ofNullable((StreamingHuggingFaceErrorResponseEntity)args[0]));
        private static final ConstructingObjectParser<StreamingHuggingFaceErrorResponseEntity, Void> ERROR_BODY_PARSER = new ConstructingObjectParser("hugging_face_error", true, args -> new StreamingHuggingFaceErrorResponseEntity(args[0] != null ? (String)args[0] : "unknown", (Integer)args[1]));
        @Nullable
        private final Integer httpStatusCode;

        private static ErrorResponse fromString(String response) {
            ErrorResponse errorResponse;
            block8: {
                XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response);
                try {
                    errorResponse = ((Optional)ERROR_PARSER.apply(parser, null)).orElse(ErrorResponse.UNDEFINED_ERROR);
                    if (parser == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        return ErrorResponse.UNDEFINED_ERROR;
                    }
                }
                parser.close();
            }
            return errorResponse;
        }

        StreamingHuggingFaceErrorResponseEntity(String errorMessage, @Nullable Integer httpStatusCode) {
            super(errorMessage);
            this.httpStatusCode = httpStatusCode;
        }

        @Nullable
        public Integer httpStatusCode() {
            return this.httpStatusCode;
        }

        static {
            ERROR_BODY_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("message", new String[0]));
            ERROR_BODY_PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("http_status_code", new String[0]));
            ERROR_PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), ERROR_BODY_PARSER, null, new ParseField("error", new String[0]));
        }
    }
}

