/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.request;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.googlevertexai.embeddings.GoogleVertexAiEmbeddingsTaskSettings;

public record GoogleVertexAiEmbeddingsRequestEntity(List<String> inputs, InputType inputType, GoogleVertexAiEmbeddingsTaskSettings taskSettings) implements ToXContentObject
{
    private static final String INSTANCES_FIELD = "instances";
    private static final String CONTENT_FIELD = "content";
    private static final String PARAMETERS_FIELD = "parameters";
    private static final String AUTO_TRUNCATE_FIELD = "autoTruncate";
    private static final String TASK_TYPE_FIELD = "task_type";
    private static final String CLASSIFICATION_TASK_TYPE = "CLASSIFICATION";
    private static final String CLUSTERING_TASK_TYPE = "CLUSTERING";
    private static final String RETRIEVAL_DOCUMENT_TASK_TYPE = "RETRIEVAL_DOCUMENT";
    private static final String RETRIEVAL_QUERY_TASK_TYPE = "RETRIEVAL_QUERY";

    public GoogleVertexAiEmbeddingsRequestEntity {
        Objects.requireNonNull(inputs);
        Objects.requireNonNull(taskSettings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(INSTANCES_FIELD);
        for (String input : this.inputs) {
            builder.startObject();
            builder.field(CONTENT_FIELD, input);
            if (InputType.isSpecified((InputType)this.inputType)) {
                builder.field(TASK_TYPE_FIELD, GoogleVertexAiEmbeddingsRequestEntity.convertToString(this.inputType));
            } else if (InputType.isSpecified((InputType)this.taskSettings.getInputType())) {
                builder.field(TASK_TYPE_FIELD, GoogleVertexAiEmbeddingsRequestEntity.convertToString(this.taskSettings.getInputType()));
            }
            builder.endObject();
        }
        builder.endArray();
        if (this.taskSettings.autoTruncate() != null) {
            builder.startObject(PARAMETERS_FIELD);
            builder.field(AUTO_TRUNCATE_FIELD, this.taskSettings.autoTruncate());
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static String convertToString(InputType inputType) {
        return switch (inputType) {
            case InputType.INGEST, InputType.INTERNAL_INGEST -> RETRIEVAL_DOCUMENT_TASK_TYPE;
            case InputType.SEARCH, InputType.INTERNAL_SEARCH -> RETRIEVAL_QUERY_TASK_TYPE;
            case InputType.CLASSIFICATION -> CLASSIFICATION_TASK_TYPE;
            case InputType.CLUSTERING -> CLUSTERING_TASK_TYPE;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)InputType.invalidInputTypeMessage((InputType)inputType));
                }
                yield null;
            }
        };
    }
}

