/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.embeddings;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiService;
import org.elasticsearch.xpack.inference.services.googlevertexai.embeddings.GoogleVertexAiEmbeddingsRequestTaskSettings;

public class GoogleVertexAiEmbeddingsTaskSettings
implements TaskSettings {
    public static final String NAME = "google_vertex_ai_embeddings_task_settings";
    public static final String AUTO_TRUNCATE = "auto_truncate";
    public static final String INPUT_TYPE = "input_type";
    public static final GoogleVertexAiEmbeddingsTaskSettings EMPTY_SETTINGS = new GoogleVertexAiEmbeddingsTaskSettings(null, null);
    private final InputType inputType;
    private final Boolean autoTruncate;

    public static GoogleVertexAiEmbeddingsTaskSettings fromMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        ValidationException validationException = new ValidationException();
        InputType inputType = ServiceUtils.extractOptionalEnum(map, INPUT_TYPE, "task_settings", InputType::fromString, GoogleVertexAiService.VALID_INPUT_TYPE_VALUES, validationException);
        Boolean autoTruncate = ServiceUtils.extractOptionalBoolean(map, AUTO_TRUNCATE, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new GoogleVertexAiEmbeddingsTaskSettings(autoTruncate, inputType);
    }

    public static GoogleVertexAiEmbeddingsTaskSettings of(GoogleVertexAiEmbeddingsTaskSettings originalSettings, GoogleVertexAiEmbeddingsRequestTaskSettings requestSettings) {
        InputType inputTypeToUse = GoogleVertexAiEmbeddingsTaskSettings.getValidInputType(originalSettings, requestSettings);
        Boolean autoTruncate = requestSettings.autoTruncate() == null ? originalSettings.autoTruncate : requestSettings.autoTruncate();
        return new GoogleVertexAiEmbeddingsTaskSettings(autoTruncate, inputTypeToUse);
    }

    private static InputType getValidInputType(GoogleVertexAiEmbeddingsTaskSettings originalSettings, GoogleVertexAiEmbeddingsRequestTaskSettings requestTaskSettings) {
        InputType inputTypeToUse = originalSettings.inputType;
        if (requestTaskSettings.inputType() != null) {
            inputTypeToUse = requestTaskSettings.inputType();
        }
        return inputTypeToUse;
    }

    public GoogleVertexAiEmbeddingsTaskSettings(@Nullable Boolean autoTruncate, @Nullable InputType inputType) {
        GoogleVertexAiEmbeddingsTaskSettings.validateInputType(inputType);
        this.inputType = inputType;
        this.autoTruncate = autoTruncate;
    }

    public GoogleVertexAiEmbeddingsTaskSettings(StreamInput in) throws IOException {
        this.autoTruncate = in.readOptionalBoolean();
        InputType inputType = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.VERTEX_AI_INPUT_TYPE_ADDED) ? (InputType)in.readOptionalEnum(InputType.class) : null;
        GoogleVertexAiEmbeddingsTaskSettings.validateInputType(inputType);
        this.inputType = inputType;
    }

    private static void validateInputType(InputType inputType) {
        if (inputType == null) {
            return;
        }
        assert (GoogleVertexAiService.VALID_INPUT_TYPE_VALUES.contains(inputType)) : InputType.invalidInputTypeMessage((InputType)inputType);
    }

    public boolean isEmpty() {
        return this.inputType == null && this.autoTruncate == null;
    }

    public Boolean autoTruncate() {
        return this.autoTruncate;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_15_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalBoolean(this.autoTruncate);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.VERTEX_AI_INPUT_TYPE_ADDED)) {
            out.writeOptionalEnum((Enum)this.inputType);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.inputType != null) {
            builder.field(INPUT_TYPE, (Enum)this.inputType);
        }
        if (this.autoTruncate != null) {
            builder.field(AUTO_TRUNCATE, this.autoTruncate);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GoogleVertexAiEmbeddingsTaskSettings that = (GoogleVertexAiEmbeddingsTaskSettings)object;
        return Objects.equals(this.inputType, that.inputType) && Objects.equals(this.autoTruncate, that.autoTruncate);
    }

    public int hashCode() {
        return Objects.hash(this.autoTruncate, this.inputType);
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        GoogleVertexAiEmbeddingsRequestTaskSettings updatedSettings = GoogleVertexAiEmbeddingsRequestTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return GoogleVertexAiEmbeddingsTaskSettings.of(this, updatedSettings);
    }
}

