/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.action;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SingleInputSenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.ChatCompletionInput;
import org.elasticsearch.xpack.inference.external.http.sender.GenericRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiEmbeddingsRequestManager;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiRerankRequestManager;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiResponseHandler;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiUnifiedChatCompletionResponseHandler;
import org.elasticsearch.xpack.inference.services.googlevertexai.action.GoogleVertexAiActionVisitor;
import org.elasticsearch.xpack.inference.services.googlevertexai.completion.GoogleVertexAiChatCompletionModel;
import org.elasticsearch.xpack.inference.services.googlevertexai.embeddings.GoogleVertexAiEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.googlevertexai.request.GoogleVertexAiUnifiedChatCompletionRequest;
import org.elasticsearch.xpack.inference.services.googlevertexai.rerank.GoogleVertexAiRerankModel;
import org.elasticsearch.xpack.inference.services.googlevertexai.response.GoogleVertexAiCompletionResponseEntity;

public class GoogleVertexAiActionCreator
implements GoogleVertexAiActionVisitor {
    public static final String COMPLETION_ERROR_PREFIX = "Google VertexAI chat completion";
    private final Sender sender;
    private final ServiceComponents serviceComponents;
    static final ResponseHandler CHAT_COMPLETION_HANDLER = new GoogleVertexAiResponseHandler("Google VertexAI completion", GoogleVertexAiCompletionResponseEntity::fromResponse, GoogleVertexAiUnifiedChatCompletionResponseHandler.GoogleVertexAiErrorResponse::fromResponse, true);
    static final String USER_ROLE = "user";

    public GoogleVertexAiActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(GoogleVertexAiEmbeddingsModel model, Map<String, Object> taskSettings) {
        GoogleVertexAiEmbeddingsModel overriddenModel = GoogleVertexAiEmbeddingsModel.of(model, taskSettings);
        GoogleVertexAiEmbeddingsRequestManager requestManager = new GoogleVertexAiEmbeddingsRequestManager(overriddenModel, this.serviceComponents.truncator(), this.serviceComponents.threadPool());
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage("Google Vertex AI embeddings");
        return new SenderExecutableAction(this.sender, requestManager, failedToSendRequestErrorMessage);
    }

    @Override
    public ExecutableAction create(GoogleVertexAiRerankModel model, Map<String, Object> taskSettings) {
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage("Google Vertex AI rerank");
        GoogleVertexAiRerankRequestManager requestManager = GoogleVertexAiRerankRequestManager.of(model, this.serviceComponents.threadPool());
        return new SenderExecutableAction(this.sender, requestManager, failedToSendRequestErrorMessage);
    }

    @Override
    public ExecutableAction create(GoogleVertexAiChatCompletionModel model, Map<String, Object> taskSettings) {
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage(COMPLETION_ERROR_PREFIX);
        GenericRequestManager<ChatCompletionInput> manager = new GenericRequestManager<ChatCompletionInput>(this.serviceComponents.threadPool(), model, CHAT_COMPLETION_HANDLER, inputs -> new GoogleVertexAiUnifiedChatCompletionRequest(new UnifiedChatInput((ChatCompletionInput)inputs, USER_ROLE), model), ChatCompletionInput.class);
        return new SingleInputSenderExecutableAction(this.sender, manager, failedToSendRequestErrorMessage, COMPLETION_ERROR_PREFIX);
    }
}

