/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic;

import java.util.Objects;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xpack.inference.services.RateLimitGroupingModel;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceComponents;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public abstract class ElasticInferenceServiceModel
extends RateLimitGroupingModel {
    private final ElasticInferenceServiceRateLimitServiceSettings rateLimitServiceSettings;
    private final ElasticInferenceServiceComponents elasticInferenceServiceComponents;

    public ElasticInferenceServiceModel(ModelConfigurations configurations, ModelSecrets secrets, ElasticInferenceServiceRateLimitServiceSettings rateLimitServiceSettings, ElasticInferenceServiceComponents elasticInferenceServiceComponents) {
        super(configurations, secrets);
        this.rateLimitServiceSettings = Objects.requireNonNull(rateLimitServiceSettings);
        this.elasticInferenceServiceComponents = Objects.requireNonNull(elasticInferenceServiceComponents);
    }

    public ElasticInferenceServiceModel(ElasticInferenceServiceModel model, ServiceSettings serviceSettings) {
        super((RateLimitGroupingModel)model, serviceSettings);
        this.rateLimitServiceSettings = model.rateLimitServiceSettings;
        this.elasticInferenceServiceComponents = model.elasticInferenceServiceComponents();
    }

    @Override
    public int rateLimitGroupingHash() {
        return Objects.hash(this.getServiceSettings().modelId());
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ElasticInferenceServiceModel that = (ElasticInferenceServiceModel)((Object)o);
        return Objects.equals(this.rateLimitServiceSettings, that.rateLimitServiceSettings) && Objects.equals(this.elasticInferenceServiceComponents, that.elasticInferenceServiceComponents);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.rateLimitServiceSettings, this.elasticInferenceServiceComponents);
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitServiceSettings.rateLimitSettings();
    }

    public ElasticInferenceServiceComponents elasticInferenceServiceComponents() {
        return this.elasticInferenceServiceComponents;
    }
}

