/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.custom.response;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingFloatResults;
import org.elasticsearch.xpack.inference.common.MapPathExtractor;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.custom.response.BaseCustomResponseParser;

public class TextEmbeddingResponseParser
extends BaseCustomResponseParser<TextEmbeddingFloatResults> {
    public static final String NAME = "text_embedding_response_parser";
    public static final String TEXT_EMBEDDING_PARSER_EMBEDDINGS = "text_embeddings";
    private final String textEmbeddingsPath;

    public static TextEmbeddingResponseParser fromMap(Map<String, Object> responseParserMap, String scope, ValidationException validationException) {
        String path = ServiceUtils.extractRequiredString(responseParserMap, TEXT_EMBEDDING_PARSER_EMBEDDINGS, String.join((CharSequence)".", scope, "json_parser"), validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new TextEmbeddingResponseParser(path);
    }

    public TextEmbeddingResponseParser(String textEmbeddingsPath) {
        this.textEmbeddingsPath = Objects.requireNonNull(textEmbeddingsPath);
    }

    public TextEmbeddingResponseParser(StreamInput in) throws IOException {
        this.textEmbeddingsPath = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.textEmbeddingsPath);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("json_parser");
        builder.field(TEXT_EMBEDDING_PARSER_EMBEDDINGS, this.textEmbeddingsPath);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextEmbeddingResponseParser that = (TextEmbeddingResponseParser)o;
        return Objects.equals(this.textEmbeddingsPath, that.textEmbeddingsPath);
    }

    public int hashCode() {
        return Objects.hash(this.textEmbeddingsPath);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected TextEmbeddingFloatResults transform(Map<String, Object> map) {
        MapPathExtractor.Result extractedResult = MapPathExtractor.extract(map, this.textEmbeddingsPath);
        List<?> mapResultsList = TextEmbeddingResponseParser.validateList(extractedResult.extractedObject(), extractedResult.getArrayFieldName(0));
        ArrayList<TextEmbeddingFloatResults.Embedding> embeddings = new ArrayList<TextEmbeddingFloatResults.Embedding>(mapResultsList.size());
        for (int i = 0; i < mapResultsList.size(); ++i) {
            try {
                Object entry = mapResultsList.get(i);
                List<Float> embeddingsAsListFloats = TextEmbeddingResponseParser.convertToListOfFloats(entry, extractedResult.getArrayFieldName(1));
                embeddings.add(TextEmbeddingFloatResults.Embedding.of(embeddingsAsListFloats));
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(Strings.format((String)"Failed to parse text embedding entry [%d], error: %s", (Object[])new Object[]{i, e.getMessage()}), e);
            }
        }
        return new TextEmbeddingFloatResults(embeddings);
    }
}

