/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.cohere.request.v2;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.cohere.CohereAccount;
import org.elasticsearch.xpack.inference.services.cohere.embeddings.CohereEmbeddingType;
import org.elasticsearch.xpack.inference.services.cohere.embeddings.CohereEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.cohere.embeddings.CohereEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.cohere.request.CohereRequest;
import org.elasticsearch.xpack.inference.services.cohere.request.CohereUtils;

public class CohereV2EmbeddingsRequest
extends CohereRequest {
    private final List<String> input;
    private final InputType inputType;
    private final CohereEmbeddingsTaskSettings taskSettings;
    private final CohereEmbeddingType embeddingType;

    public CohereV2EmbeddingsRequest(List<String> input, InputType inputType, CohereEmbeddingsModel embeddingsModel) {
        super(CohereAccount.of(embeddingsModel), embeddingsModel.getInferenceEntityId(), Objects.requireNonNull(embeddingsModel.getServiceSettings().getCommonSettings().modelId()), false);
        this.input = Objects.requireNonNull(input);
        this.inputType = Optional.ofNullable(inputType).orElse(InputType.SEARCH);
        this.taskSettings = embeddingsModel.getTaskSettings();
        this.embeddingType = embeddingsModel.getServiceSettings().getEmbeddingType();
    }

    @Override
    protected List<String> pathSegments() {
        return List.of("v2", "embed");
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("texts", this.input);
        builder.field("model", this.getModelId());
        if (InputType.isSpecified((InputType)this.inputType)) {
            builder.field("input_type", CohereUtils.inputTypeToString(this.inputType));
        } else if (InputType.isSpecified((InputType)this.taskSettings.getInputType())) {
            builder.field("input_type", CohereUtils.inputTypeToString(this.taskSettings.getInputType()));
        }
        builder.field("embedding_types", List.of(this.embeddingType.toRequestString()));
        if (this.taskSettings.getTruncation() != null) {
            builder.field("truncate", (Enum)this.taskSettings.getTruncation());
        }
        builder.endObject();
        return builder;
    }
}

