/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.request.embeddings;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.amazonbedrock.embeddings.AmazonBedrockEmbeddingsTaskSettings;

public record AmazonBedrockCohereEmbeddingsRequestEntity(List<String> input, @Nullable InputType inputType, AmazonBedrockEmbeddingsTaskSettings taskSettings) implements ToXContentObject
{
    private static final String TEXTS_FIELD = "texts";
    private static final String INPUT_TYPE_FIELD = "input_type";
    private static final String SEARCH_DOCUMENT = "search_document";
    private static final String SEARCH_QUERY = "search_query";
    private static final String CLUSTERING = "clustering";
    private static final String CLASSIFICATION = "classification";
    private static final String TRUNCATE = "truncate";

    public AmazonBedrockCohereEmbeddingsRequestEntity {
        Objects.requireNonNull(input);
        Objects.requireNonNull(taskSettings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TEXTS_FIELD, this.input);
        if (InputType.isSpecified((InputType)this.inputType)) {
            builder.field(INPUT_TYPE_FIELD, AmazonBedrockCohereEmbeddingsRequestEntity.convertToString(this.inputType));
        } else {
            builder.field(INPUT_TYPE_FIELD, SEARCH_DOCUMENT);
        }
        if (this.taskSettings.cohereTruncation() != null) {
            builder.field(TRUNCATE, this.taskSettings.cohereTruncation().name());
        }
        builder.endObject();
        return builder;
    }

    static String convertToString(InputType inputType) {
        return switch (inputType) {
            case InputType.INGEST, InputType.INTERNAL_INGEST -> SEARCH_DOCUMENT;
            case InputType.SEARCH, InputType.INTERNAL_SEARCH -> SEARCH_QUERY;
            case InputType.CLASSIFICATION -> CLASSIFICATION;
            case InputType.CLUSTERING -> CLUSTERING;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)InputType.invalidInputTypeMessage((InputType)inputType));
                }
                yield null;
            }
        };
    }
}

