/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.alibabacloudsearch.response;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.RankedDocsResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;

public class AlibabaCloudSearchRerankResponseEntity {
    private static final String FAILED_TO_FIND_FIELD_TEMPLATE = "Failed to find required field [%s] in AlibabaCloud Search rerank response";
    private static final Logger logger = LogManager.getLogger(AlibabaCloudSearchRerankResponseEntity.class);

    public static InferenceServiceResults fromResponse(Request request, HttpResult response) throws IOException {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, response.body());){
            XContentUtils.moveToFirstToken(jsonParser);
            XContentParser.Token token = jsonParser.currentToken();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)jsonParser);
            XContentUtils.positionParserAtTokenAfterField(jsonParser, "result", FAILED_TO_FIND_FIELD_TEMPLATE);
            XContentUtils.positionParserAtTokenAfterField(jsonParser, "scores", FAILED_TO_FIND_FIELD_TEMPLATE);
            token = jsonParser.currentToken();
            if (token == XContentParser.Token.START_ARRAY) {
                RankedDocsResults rankedDocsResults = new RankedDocsResults(XContentParserUtils.parseList((XContentParser)jsonParser, AlibabaCloudSearchRerankResponseEntity::parseRankedDocObject));
                return rankedDocsResults;
            }
            XContentParserUtils.throwUnknownToken((XContentParser.Token)token, (XContentParser)jsonParser);
            throw new IllegalStateException("Reached an invalid state while parsing the AlibabaCloudSearch response");
        }
    }

    private static RankedDocsResults.RankedDoc parseRankedDocObject(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        int index = -1;
        float score = -1.0f;
        String documentText = null;
        parser.nextToken();
        block8: while (parser.currentToken() != XContentParser.Token.END_OBJECT) {
            if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                switch (parser.currentName()) {
                    case "index": {
                        parser.nextToken();
                        index = parser.intValue();
                        parser.nextToken();
                        continue block8;
                    }
                    case "score": {
                        parser.nextToken();
                        score = parser.floatValue();
                        parser.nextToken();
                        continue block8;
                    }
                }
                XContentParserUtils.throwUnknownField((String)parser.currentName(), (XContentParser)parser);
                continue;
            }
            parser.nextToken();
        }
        if (index == -1) {
            logger.warn("Failed to find required field [index] in AlibabaCloudSearch rerank response");
        }
        if (score == -1.0f) {
            logger.warn("Failed to find required field [relevance_score] in AlibabaCloudSearch rerank response");
        }
        return new RankedDocsResults.RankedDoc(index, score, documentText);
    }
}

