/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.response.streaming;

import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;

public class StreamingErrorResponse
extends ErrorResponse {
    private static final ConstructingObjectParser<Optional<ErrorResponse>, Void> ERROR_PARSER = new ConstructingObjectParser("streaming_error", true, args -> Optional.ofNullable((StreamingErrorResponse)args[0]));
    private static final ConstructingObjectParser<StreamingErrorResponse, Void> ERROR_BODY_PARSER = new ConstructingObjectParser("streaming_error", true, args -> new StreamingErrorResponse((String)args[0], (String)args[1], (String)args[2], (String)args[3]));
    @Nullable
    private final String code;
    @Nullable
    private final String param;
    private final String type;

    public static ErrorResponse fromResponse(HttpResult response) {
        ErrorResponse errorResponse;
        block8: {
            XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response.body());
            try {
                errorResponse = ((Optional)ERROR_PARSER.apply(parser, null)).orElse(ErrorResponse.UNDEFINED_ERROR);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return ErrorResponse.UNDEFINED_ERROR;
                }
            }
            parser.close();
        }
        return errorResponse;
    }

    public static ErrorResponse fromString(String response) {
        ErrorResponse errorResponse;
        block8: {
            XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response);
            try {
                errorResponse = ((Optional)ERROR_PARSER.apply(parser, null)).orElse(ErrorResponse.UNDEFINED_ERROR);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return ErrorResponse.UNDEFINED_ERROR;
                }
            }
            parser.close();
        }
        return errorResponse;
    }

    StreamingErrorResponse(String errorMessage, @Nullable String code, @Nullable String param, String type) {
        super(errorMessage);
        this.code = code;
        this.param = param;
        this.type = Objects.requireNonNull(type);
    }

    @Nullable
    public String code() {
        return this.code;
    }

    @Nullable
    public String param() {
        return this.param;
    }

    public String type() {
        return this.type;
    }

    static {
        ERROR_BODY_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("message", new String[0]));
        ERROR_BODY_PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("code", new String[0]));
        ERROR_BODY_PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("param", new String[0]));
        ERROR_BODY_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
        ERROR_PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), ERROR_BODY_PARSER, null, new ParseField("error", new String[0]));
    }
}

