/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;

public class QueryAndDocsInputs
extends InferenceInputs {
    private final String query;
    private final List<String> chunks;
    private final Boolean returnDocuments;
    private final Integer topN;

    public static QueryAndDocsInputs of(InferenceInputs inferenceInputs) {
        if (!(inferenceInputs instanceof QueryAndDocsInputs)) {
            throw QueryAndDocsInputs.createUnsupportedTypeException(inferenceInputs, QueryAndDocsInputs.class);
        }
        return (QueryAndDocsInputs)inferenceInputs;
    }

    public QueryAndDocsInputs(String query, List<String> chunks, @Nullable Boolean returnDocuments, @Nullable Integer topN, boolean stream) {
        super(stream);
        this.query = Objects.requireNonNull(query);
        this.chunks = Objects.requireNonNull(chunks);
        this.returnDocuments = returnDocuments;
        this.topN = topN;
    }

    public QueryAndDocsInputs(String query, List<String> chunks) {
        this(query, chunks, null, null, false);
    }

    public String getQuery() {
        return this.query;
    }

    public List<String> getChunks() {
        return this.chunks;
    }

    public Boolean getReturnDocuments() {
        return this.returnDocuments;
    }

    public Integer getTopN() {
        return this.topN;
    }

    @Override
    public boolean isSingleInput() {
        return this.chunks.size() == 1;
    }
}

