/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.chunking;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.ChunkingStrategy;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.chunking.ChunkingSettingsOptions;
import org.elasticsearch.xpack.inference.chunking.SeparatorGroup;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class RecursiveChunkingSettings
implements ChunkingSettings {
    public static final String NAME = "RecursiveChunkingSettings";
    private static final ChunkingStrategy STRATEGY = ChunkingStrategy.RECURSIVE;
    private static final int MAX_CHUNK_SIZE_LOWER_LIMIT = 10;
    private static final int MAX_CHUNK_SIZE_UPPER_LIMIT = 300;
    private static final Set<String> VALID_KEYS = Set.of(ChunkingSettingsOptions.STRATEGY.toString(), ChunkingSettingsOptions.MAX_CHUNK_SIZE.toString(), ChunkingSettingsOptions.SEPARATOR_GROUP.toString(), ChunkingSettingsOptions.SEPARATORS.toString());
    private final int maxChunkSize;
    private final List<String> separators;

    public RecursiveChunkingSettings(int maxChunkSize, List<String> separators) {
        this.maxChunkSize = maxChunkSize;
        this.separators = separators == null ? SeparatorGroup.PLAINTEXT.getSeparators() : separators;
    }

    public RecursiveChunkingSettings(StreamInput in) throws IOException {
        this.maxChunkSize = in.readInt();
        this.separators = in.readCollectionAsList(StreamInput::readString);
    }

    public static RecursiveChunkingSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        Object[] invalidSettings = map.keySet().stream().filter(key -> !VALID_KEYS.contains(key)).toArray();
        if (invalidSettings.length > 0) {
            validationException.addValidationError(Strings.format((String)"Recursive chunking settings can not have the following settings: %s", (Object[])new Object[]{Arrays.toString(invalidSettings)}));
        }
        Integer maxChunkSize = ServiceUtils.extractRequiredPositiveIntegerBetween(map, ChunkingSettingsOptions.MAX_CHUNK_SIZE.toString(), 10, 300, "chunking_settings", validationException);
        SeparatorGroup separatorGroup = ServiceUtils.extractOptionalEnum(map, ChunkingSettingsOptions.SEPARATOR_GROUP.toString(), "chunking_settings", SeparatorGroup::fromString, EnumSet.allOf(SeparatorGroup.class), validationException);
        List<String> separators = ServiceUtils.extractOptionalList(map, ChunkingSettingsOptions.SEPARATORS.toString(), String.class, validationException);
        if (separators != null && separatorGroup != null) {
            validationException.addValidationError("Recursive chunking settings can not have both separators and separator_set");
        }
        if (separatorGroup != null) {
            separators = separatorGroup.getSeparators();
        } else if (separators != null && separators.isEmpty()) {
            validationException.addValidationError("Recursive chunking settings can not have an empty list of separators");
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new RecursiveChunkingSettings(maxChunkSize, separators);
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public List<String> getSeparators() {
        return this.separators;
    }

    public ChunkingStrategy getChunkingStrategy() {
        return STRATEGY;
    }

    public Map<String, Object> asMap() {
        return Map.of(ChunkingSettingsOptions.STRATEGY.toString(), STRATEGY.toString().toLowerCase(Locale.ROOT), ChunkingSettingsOptions.MAX_CHUNK_SIZE.toString(), this.maxChunkSize, ChunkingSettingsOptions.SEPARATORS.toString(), this.separators);
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.maxChunkSize);
        out.writeCollection(this.separators, StreamOutput::writeString);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ChunkingSettingsOptions.STRATEGY.toString(), (Enum)STRATEGY);
        builder.field(ChunkingSettingsOptions.MAX_CHUNK_SIZE.toString(), this.maxChunkSize);
        builder.field(ChunkingSettingsOptions.SEPARATORS.toString(), this.separators);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecursiveChunkingSettings that = (RecursiveChunkingSettings)o;
        return Objects.equals(this.maxChunkSize, that.maxChunkSize) && Objects.equals(this.separators, that.separators);
    }

    public int hashCode() {
        return Objects.hash(this.maxChunkSize, this.separators);
    }
}

