/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.chunking;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.ChunkingStrategy;
import org.elasticsearch.xpack.inference.chunking.ChunkingSettingsOptions;
import org.elasticsearch.xpack.inference.chunking.NoneChunkingSettings;
import org.elasticsearch.xpack.inference.chunking.RecursiveChunkingSettings;
import org.elasticsearch.xpack.inference.chunking.SentenceBoundaryChunkingSettings;
import org.elasticsearch.xpack.inference.chunking.WordBoundaryChunkingSettings;

public class ChunkingSettingsBuilder {
    public static final SentenceBoundaryChunkingSettings DEFAULT_SETTINGS = new SentenceBoundaryChunkingSettings(250, 1);
    public static final WordBoundaryChunkingSettings OLD_DEFAULT_SETTINGS = new WordBoundaryChunkingSettings(250, 100);

    public static ChunkingSettings fromMap(Map<String, Object> settings) {
        return ChunkingSettingsBuilder.fromMap(settings, true);
    }

    public static ChunkingSettings fromMap(Map<String, Object> settings, boolean returnDefaultValues) {
        if (returnDefaultValues) {
            if (settings == null) {
                return OLD_DEFAULT_SETTINGS;
            }
            if (settings.isEmpty()) {
                return DEFAULT_SETTINGS;
            }
        } else if (settings == null || settings.isEmpty()) {
            return null;
        }
        if (!settings.containsKey(ChunkingSettingsOptions.STRATEGY.toString())) {
            throw new IllegalArgumentException("Can't generate Chunker without ChunkingStrategy provided");
        }
        ChunkingStrategy chunkingStrategy = ChunkingStrategy.fromString((String)settings.get(ChunkingSettingsOptions.STRATEGY.toString()).toString());
        return switch (chunkingStrategy) {
            default -> throw new IncompatibleClassChangeError();
            case ChunkingStrategy.NONE -> NoneChunkingSettings.INSTANCE;
            case ChunkingStrategy.WORD -> WordBoundaryChunkingSettings.fromMap(new HashMap<String, Object>(settings));
            case ChunkingStrategy.SENTENCE -> SentenceBoundaryChunkingSettings.fromMap(new HashMap<String, Object>(settings));
            case ChunkingStrategy.RECURSIVE -> RecursiveChunkingSettings.fromMap(new HashMap<String, Object>(settings));
        };
    }
}

