/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.scanner;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;

public class AnnotatedHierarchyVisitor
extends ClassVisitor {
    private String currentClassName;
    private final String targetAnnotationDescriptor;
    private final Function<String, AnnotationVisitor> visitor;
    private final Map<String, Set<String>> classToSubclasses = new HashMap<String, Set<String>>();
    private static final String OBJECT_NAME = Object.class.getCanonicalName().replace('.', '/');

    AnnotatedHierarchyVisitor(String targetAnnotation, Function<String, AnnotationVisitor> annotationVisitor) {
        super(589824);
        this.targetAnnotationDescriptor = targetAnnotation;
        this.visitor = annotationVisitor;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.currentClassName = name;
        if (!OBJECT_NAME.equals(superName)) {
            this.classToSubclasses.computeIfAbsent(superName, k -> new HashSet()).add(name);
        }
        for (String iface : interfaces) {
            this.classToSubclasses.computeIfAbsent(iface, k -> new HashSet()).add(name);
        }
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        if (descriptor.equals(this.targetAnnotationDescriptor)) {
            return this.visitor.apply(this.currentClassName);
        }
        return null;
    }

    public Map<String, Set<String>> getClassHierarchy() {
        return this.classToSubclasses;
    }
}

