/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.history;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;

public class ILMHistoryItem
implements ToXContentObject {
    private static final ParseField INDEX = new ParseField("index", new String[0]);
    private static final ParseField POLICY = new ParseField("policy", new String[0]);
    private static final ParseField TIMESTAMP = new ParseField("@timestamp", new String[0]);
    private static final ParseField INDEX_AGE = new ParseField("index_age", new String[0]);
    private static final ParseField SUCCESS = new ParseField("success", new String[0]);
    private static final ParseField EXECUTION_STATE = new ParseField("state", new String[0]);
    private static final ParseField ERROR = new ParseField("error_details", new String[0]);
    private final String index;
    private final String policyId;
    private final long timestamp;
    @Nullable
    private final Long indexAge;
    private final boolean success;
    @Nullable
    private final LifecycleExecutionState executionState;
    @Nullable
    private final String errorDetails;

    private ILMHistoryItem(String index, String policyId, long timestamp, @Nullable Long indexAge, boolean success, @Nullable LifecycleExecutionState executionState, @Nullable String errorDetails) {
        this.index = index;
        this.policyId = policyId;
        this.timestamp = timestamp;
        this.indexAge = indexAge;
        this.success = success;
        this.executionState = executionState;
        this.errorDetails = errorDetails;
    }

    public static ILMHistoryItem success(String index, String policyId, long timestamp, @Nullable Long indexAge, @Nullable LifecycleExecutionState executionState) {
        return new ILMHistoryItem(index, policyId, timestamp, indexAge, true, executionState, null);
    }

    public static ILMHistoryItem failure(String index, String policyId, long timestamp, @Nullable Long indexAge, @Nullable LifecycleExecutionState executionState, Exception error) {
        Objects.requireNonNull(error, "ILM failures require an attached exception");
        String fullErrorString = ILMHistoryItem.exceptionToString(error);
        String truncatedErrorString = LifecycleExecutionState.potentiallyTruncateLongJsonWithExplanation((String)fullErrorString);
        return new ILMHistoryItem(index, policyId, timestamp, indexAge, false, executionState, truncatedErrorString);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX.getPreferredName(), this.index);
        builder.field(POLICY.getPreferredName(), this.policyId);
        builder.field(TIMESTAMP.getPreferredName(), this.timestamp);
        if (this.indexAge != null) {
            builder.field(INDEX_AGE.getPreferredName(), this.indexAge);
        }
        builder.field(SUCCESS.getPreferredName(), this.success);
        if (this.executionState != null) {
            builder.stringStringMap(EXECUTION_STATE.getPreferredName(), this.executionState.asMap());
        }
        if (this.errorDetails != null) {
            builder.field(ERROR.getPreferredName(), this.errorDetails);
        }
        builder.endObject();
        return builder;
    }

    private static String exceptionToString(Exception exception) {
        Object exceptionString;
        ToXContent.MapParams stacktraceParams = new ToXContent.MapParams(Map.of("rest.exception.stacktrace.skip", "false"));
        try (XContentBuilder causeXContentBuilder = JsonXContent.contentBuilder();){
            causeXContentBuilder.startObject();
            ElasticsearchException.generateThrowableXContent((XContentBuilder)causeXContentBuilder, (ToXContent.Params)stacktraceParams, (Throwable)exception);
            causeXContentBuilder.endObject();
            exceptionString = BytesReference.bytes((XContentBuilder)causeXContentBuilder).utf8ToString();
        }
        catch (IOException e) {
            exceptionString = "unable to generate the ILM error details due to: " + e.getMessage() + "; the ILM error was: " + exception.getMessage();
        }
        return exceptionString;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

