/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit.integrity;

import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.blobstore.testkit.integrity.ActiveRepositoryVerifyIntegrityTasks;
import org.elasticsearch.repositories.blobstore.testkit.integrity.RepositoryVerifyIntegrityParams;
import org.elasticsearch.repositories.blobstore.testkit.integrity.RepositoryVerifyIntegrityResponse;
import org.elasticsearch.repositories.blobstore.testkit.integrity.RepositoryVerifyIntegrityResponseStream;
import org.elasticsearch.repositories.blobstore.testkit.integrity.TransportRepositoryVerifyIntegrityAction;
import org.elasticsearch.repositories.blobstore.testkit.integrity.TransportRepositoryVerifyIntegrityResponseChunkAction;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class TransportRepositoryVerifyIntegrityCoordinationAction
extends TransportAction<Request, RepositoryVerifyIntegrityResponse> {
    public static final ActionType<RepositoryVerifyIntegrityResponse> INSTANCE = new ActionType("cluster:admin/repository/verify_integrity");
    private final ActiveRepositoryVerifyIntegrityTasks activeRepositoryVerifyIntegrityTasks = new ActiveRepositoryVerifyIntegrityTasks();
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final Executor managementExecutor;

    @Inject
    public TransportRepositoryVerifyIntegrityCoordinationAction(TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService, ActionFilters actionFilters) {
        super(INSTANCE.name(), actionFilters, transportService.getTaskManager(), (Executor)transportService.getThreadPool().executor("management"));
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.managementExecutor = transportService.getThreadPool().executor("management");
        new TransportRepositoryVerifyIntegrityAction(transportService, repositoriesService, actionFilters, this.managementExecutor);
        new TransportRepositoryVerifyIntegrityResponseChunkAction(transportService, actionFilters, this.managementExecutor, this.activeRepositoryVerifyIntegrityTasks);
    }

    protected void doExecute(Task task, Request request, ActionListener<RepositoryVerifyIntegrityResponse> listener) {
        ActionListener.run((ActionListener)ActionListener.releaseAfter(listener, (Releasable)this.activeRepositoryVerifyIntegrityTasks.registerResponseBuilder(task.getId(), request.responseStream())), l -> {
            DiscoveryNode master = this.clusterService.state().nodes().getMasterNode();
            if (master == null) {
                throw new MasterNotDiscoveredException();
            }
            this.transportService.sendChildRequest(master, TransportRepositoryVerifyIntegrityAction.ACTION_NAME, (TransportRequest)new TransportRepositoryVerifyIntegrityAction.Request(this.transportService.getLocalNode(), task.getId(), request.requestParams()), task, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(l, RepositoryVerifyIntegrityResponse::new, this.managementExecutor));
        });
    }

    public static class Request
    extends LegacyActionRequest {
        private final RepositoryVerifyIntegrityParams requestParams;
        private final RepositoryVerifyIntegrityResponseStream responseStream;

        public Request(RepositoryVerifyIntegrityParams requestParams, RepositoryVerifyIntegrityResponseStream responseStream) {
            this.requestParams = requestParams;
            this.responseStream = responseStream;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public RepositoryVerifyIntegrityParams requestParams() {
            return this.requestParams;
        }

        public RepositoryVerifyIntegrityResponseStream responseStream() {
            return this.responseStream;
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers);
        }
    }
}

