/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopFloatAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopFloatGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopFloatAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final List<Integer> channels;
    private final int limit;
    private final boolean ascending;

    public TopFloatAggregatorFunctionSupplier(List<Integer> channels, int limit, boolean ascending) {
        this.channels = channels;
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public TopFloatAggregatorFunction aggregator(DriverContext driverContext) {
        return TopFloatAggregatorFunction.create(driverContext, this.channels, this.limit, this.ascending);
    }

    @Override
    public TopFloatGroupingAggregatorFunction groupingAggregator(DriverContext driverContext) {
        return TopFloatGroupingAggregatorFunction.create(this.channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top of floats";
    }
}

