/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.index.engine;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.InternalEngine;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.ccr.CcrSettings;
import org.elasticsearch.xpack.ccr.index.engine.AlreadyProcessedFollowingEngineException;
import org.elasticsearch.xpack.ccr.index.engine.FollowingEngineAssertions;

public class FollowingEngine
extends InternalEngine {
    FollowingEngine(EngineConfig engineConfig) {
        super(FollowingEngine.validateEngineConfig(engineConfig));
    }

    private static EngineConfig validateEngineConfig(EngineConfig engineConfig) {
        if (!((Boolean)CcrSettings.CCR_FOLLOWING_INDEX_SETTING.get(engineConfig.getIndexSettings().getSettings())).booleanValue()) {
            throw new IllegalArgumentException("a following engine can not be constructed for a non-following index");
        }
        if (!engineConfig.getIndexSettings().isSoftDeleteEnabled()) {
            throw new IllegalArgumentException("a following engine requires soft deletes to be enabled");
        }
        return engineConfig;
    }

    private static void preFlight(Engine.Operation operation) {
        assert (FollowingEngineAssertions.preFlight(operation));
        if (operation.seqNo() == -2L) {
            throw new ElasticsearchStatusException("a following engine does not accept operations without an assigned sequence number", RestStatus.FORBIDDEN, new Object[0]);
        }
    }

    protected InternalEngine.IndexingStrategy indexingStrategyForOperation(Engine.Index index) throws IOException {
        FollowingEngine.preFlight((Engine.Operation)index);
        if (index.origin() == Engine.Operation.Origin.PRIMARY && this.hasBeenProcessedBefore((Engine.Operation)index)) {
            AlreadyProcessedFollowingEngineException error = new AlreadyProcessedFollowingEngineException(this.shardId, index.seqNo(), this.lookupPrimaryTerm(index.seqNo()));
            return InternalEngine.IndexingStrategy.skipDueToVersionConflict((VersionConflictEngineException)error, (boolean)false, (long)index.version(), (String)index.id());
        }
        return this.planIndexingAsNonPrimary(index);
    }

    protected InternalEngine.DeletionStrategy deletionStrategyForOperation(Engine.Delete delete) throws IOException {
        FollowingEngine.preFlight((Engine.Operation)delete);
        if (delete.origin() == Engine.Operation.Origin.PRIMARY && this.hasBeenProcessedBefore((Engine.Operation)delete)) {
            AlreadyProcessedFollowingEngineException error = new AlreadyProcessedFollowingEngineException(this.shardId, delete.seqNo(), this.lookupPrimaryTerm(delete.seqNo()));
            return InternalEngine.DeletionStrategy.skipDueToVersionConflict((VersionConflictEngineException)error, (long)delete.version(), (boolean)false, (String)delete.id());
        }
        return this.planDeletionAsNonPrimary(delete);
    }

    protected Optional<Exception> preFlightCheckForNoOp(Engine.NoOp noOp) throws IOException {
        if (noOp.origin() == Engine.Operation.Origin.PRIMARY && this.hasBeenProcessedBefore((Engine.Operation)noOp)) {
            OptionalLong existingTerm = this.lookupPrimaryTerm(noOp.seqNo());
            return Optional.of(new AlreadyProcessedFollowingEngineException(this.shardId, noOp.seqNo(), existingTerm));
        }
        return super.preFlightCheckForNoOp(noOp);
    }

    protected long generateSeqNoForOperationOnPrimary(Engine.Operation operation) {
        assert (operation.origin() == Engine.Operation.Origin.PRIMARY);
        assert (operation.seqNo() >= 0L) : "ops should have an assigned seq no. but was: " + operation.seqNo();
        this.markSeqNoAsSeen(operation.seqNo());
        return operation.seqNo();
    }

    protected void advanceMaxSeqNoOfDeletesOnPrimary(long seqNo) {
        if (Assertions.ENABLED) {
            long localCheckpoint = this.getProcessedLocalCheckpoint();
            long maxSeqNoOfUpdates = this.getMaxSeqNoOfUpdatesOrDeletes();
            assert (localCheckpoint < maxSeqNoOfUpdates || maxSeqNoOfUpdates >= seqNo) : "maxSeqNoOfUpdates is not advanced local_checkpoint=" + localCheckpoint + " msu=" + maxSeqNoOfUpdates + " seq_no=" + seqNo;
        }
        super.advanceMaxSeqNoOfDeletesOnPrimary(seqNo);
    }

    protected void advanceMaxSeqNoOfUpdatesOnPrimary(long seqNo) {
        super.advanceMaxSeqNoOfUpdatesOnPrimary(seqNo);
    }

    public int fillSeqNoGaps(long primaryTerm) {
        return 0;
    }

    protected boolean assertPrimaryIncomingSequenceNumber(Engine.Operation.Origin origin, long seqNo) {
        assert (FollowingEngineAssertions.assertPrimaryIncomingSequenceNumber(seqNo));
        return true;
    }

    protected boolean assertNonPrimaryOrigin(Engine.Operation operation) {
        return true;
    }

    protected boolean assertPrimaryCanOptimizeAddDocument(Engine.Index index) {
        assert (index.version() == 1L && index.versionType() == VersionType.EXTERNAL) : "version [" + index.version() + "], type [" + String.valueOf(index.versionType()) + "]";
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OptionalLong lookupPrimaryTerm(long seqNo) throws IOException {
        if (seqNo <= this.engineConfig.getGlobalCheckpointSupplier().getAsLong()) {
            return OptionalLong.empty();
        }
        this.refreshIfNeeded("lookup_primary_term", seqNo);
        try (Engine.Searcher engineSearcher = this.acquireSearcher("lookup_primary_term", Engine.SearcherScope.INTERNAL);){
            DirectoryReader reader = Lucene.wrapAllDocsLive((DirectoryReader)engineSearcher.getDirectoryReader());
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            searcher.setQueryCache(null);
            BooleanQuery query = new BooleanQuery.Builder().add(LongPoint.newExactQuery((String)"_seq_no", (long)seqNo), BooleanClause.Occur.FILTER).add((Query)new FieldExistsQuery("_primary_term"), BooleanClause.Occur.FILTER).build();
            TopDocs topDocs = searcher.search((Query)query, 1);
            if (topDocs.scoreDocs.length == 1) {
                int docId = topDocs.scoreDocs[0].doc;
                LeafReaderContext leaf = (LeafReaderContext)reader.leaves().get(ReaderUtil.subIndex((int)docId, (List)reader.leaves()));
                NumericDocValues primaryTermDV = leaf.reader().getNumericDocValues("_primary_term");
                if (primaryTermDV != null && primaryTermDV.advanceExact(docId - leaf.docBase)) {
                    assert (primaryTermDV.longValue() > 0L) : "invalid term [" + primaryTermDV.longValue() + "]";
                    OptionalLong optionalLong = OptionalLong.of(primaryTermDV.longValue());
                    return optionalLong;
                }
            }
            if (seqNo <= this.engineConfig.getGlobalCheckpointSupplier().getAsLong()) {
                OptionalLong optionalLong = OptionalLong.empty();
                return optionalLong;
            }
            if ($assertionsDisabled) throw new IllegalStateException("seq_no[" + seqNo + "] does not have primary_term (total_hits=" + String.valueOf(topDocs.totalHits) + ")");
            throw new AssertionError((Object)("seq_no[" + seqNo + "] does not have primary_term, total_hits=[" + String.valueOf(topDocs.totalHits) + "]"));
        }
        catch (IOException e) {
            try {
                this.maybeFailEngine("lookup_primary_term", e);
                throw e;
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw e;
        }
    }

    public void verifyEngineBeforeIndexClosing() throws IllegalStateException {
    }
}

