/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.kql.query;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.kql.parser.KqlParser;
import org.elasticsearch.xpack.kql.parser.KqlParsingContext;
import org.elasticsearch.xpack.kql.parser.KqlParsingException;

public class KqlQueryBuilder
extends AbstractQueryBuilder<KqlQueryBuilder> {
    public static final String NAME = "kql";
    public static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    public static final ParseField CASE_INSENSITIVE_FIELD = new ParseField("case_insensitive", new String[0]);
    public static final ParseField TIME_ZONE_FIELD = new ParseField("time_zone", new String[0]);
    public static final ParseField DEFAULT_FIELD_FIELD = new ParseField("default_field", new String[0]);
    private static final Logger log = LogManager.getLogger(KqlQueryBuilder.class);
    private static final ConstructingObjectParser<KqlQueryBuilder, Void> PARSER = new ConstructingObjectParser("kql", a -> {
        KqlQueryBuilder kqlQuery = new KqlQueryBuilder((String)a[0]);
        if (a[1] != null) {
            kqlQuery.caseInsensitive((Boolean)a[1]);
        }
        if (a[2] != null) {
            kqlQuery.timeZone((String)a[2]);
        }
        if (a[3] != null) {
            kqlQuery.defaultField((String)a[3]);
        }
        return kqlQuery;
    });
    private final String query;
    private boolean caseInsensitive = false;
    private ZoneId timeZone;
    private String defaultField;

    public KqlQueryBuilder(String query) {
        this.query = Objects.requireNonNull(query, "query can not be null");
    }

    public KqlQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.query = in.readString();
        this.caseInsensitive = in.readBoolean();
        this.timeZone = in.readOptionalZoneId();
        this.defaultField = in.readOptionalString();
    }

    public static KqlQueryBuilder fromXContent(XContentParser parser) {
        try {
            return (KqlQueryBuilder)((Object)PARSER.apply(parser, null));
        }
        catch (IllegalArgumentException e) {
            throw new ParsingException(parser.getTokenLocation(), e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.KQL_QUERY_TECH_PREVIEW;
    }

    public String queryString() {
        return this.query;
    }

    public boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    public KqlQueryBuilder caseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        return this;
    }

    public ZoneId timeZone() {
        return this.timeZone;
    }

    public KqlQueryBuilder timeZone(String timeZone) {
        this.timeZone = timeZone != null ? ZoneId.of(timeZone) : null;
        return this;
    }

    public String defaultField() {
        return this.defaultField;
    }

    public KqlQueryBuilder defaultField(String defaultField) {
        this.defaultField = defaultField;
        return this;
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName(), this.query);
        builder.field(CASE_INSENSITIVE_FIELD.getPreferredName(), this.caseInsensitive);
        if (this.defaultField != null) {
            builder.field(DEFAULT_FIELD_FIELD.getPreferredName(), this.defaultField);
        }
        if (this.timeZone != null) {
            builder.field(TIME_ZONE_FIELD.getPreferredName(), this.timeZone.getId());
        }
        this.boostAndQueryNameToXContent(builder);
        builder.endObject();
    }

    protected QueryBuilder doIndexMetadataRewrite(QueryRewriteContext context) {
        try {
            KqlParser parser = new KqlParser();
            QueryBuilder rewrittenQuery = parser.parseKqlQuery(this.query, this.createKqlParserContext(context));
            log.trace(() -> Strings.format((String)"KQL query %s translated to Query DSL: %s", (Object[])new Object[]{this.query, Strings.toString((ToXContent)rewrittenQuery)}));
            return rewrittenQuery;
        }
        catch (KqlParsingException e) {
            throw new QueryShardException(context, "Failed to parse KQL query [{}]", (Throwable)((Object)e), new Object[]{this.query});
        }
    }

    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        throw new IllegalStateException("The query should have been rewritten");
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.query);
        out.writeBoolean(this.caseInsensitive);
        out.writeOptionalZoneId(this.timeZone);
        out.writeOptionalString(this.defaultField);
    }

    public String getWriteableName() {
        return NAME;
    }

    protected int doHashCode() {
        return Objects.hash(this.query, this.caseInsensitive, this.timeZone, this.defaultField);
    }

    protected boolean doEquals(KqlQueryBuilder other) {
        return Objects.equals(this.query, other.query) && Objects.equals(this.timeZone, other.timeZone) && Objects.equals(this.defaultField, other.defaultField) && this.caseInsensitive == other.caseInsensitive;
    }

    private KqlParsingContext createKqlParserContext(QueryRewriteContext queryRewriteContext) {
        return KqlParsingContext.builder(queryRewriteContext).caseInsensitive(this.caseInsensitive).timeZone(this.timeZone).defaultField(this.defaultField).build();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), QUERY_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), CASE_INSENSITIVE_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TIME_ZONE_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), DEFAULT_FIELD_FIELD);
        KqlQueryBuilder.declareStandardFields(PARSER);
    }
}

