/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeExec;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.rule.Rule;

public class ProjectAwayColumns
extends Rule<PhysicalPlan, PhysicalPlan> {
    @Override
    public PhysicalPlan apply(PhysicalPlan plan) {
        Holder keepTraversing = new Holder((Object)Boolean.TRUE);
        Holder requiredAttributes = new Holder((Object)plan.outputSet());
        return (PhysicalPlan)plan.transformDown(currentPlanNode -> {
            if (!((Boolean)keepTraversing.get()).booleanValue()) {
                return currentPlanNode;
            }
            if (currentPlanNode instanceof ExchangeExec) {
                FragmentExec fragmentExec;
                LogicalPlan logicalFragment;
                ExchangeExec exec = (ExchangeExec)((Object)currentPlanNode);
                keepTraversing.set((Object)Boolean.FALSE);
                PhysicalPlan child = exec.child();
                if (child instanceof FragmentExec && !((logicalFragment = (fragmentExec = (FragmentExec)child).fragment()) instanceof Aggregate)) {
                    List<Object> output = new ArrayList<Attribute>();
                    for (Attribute attribute : logicalFragment.output()) {
                        if (!((AttributeSet)requiredAttributes.get()).contains((Object)attribute)) continue;
                        output.add(attribute);
                    }
                    if (output.size() != ((AttributeSet)requiredAttributes.get()).size()) {
                        AttributeSet alreadyAdded = new AttributeSet(output);
                        AttributeSet remaining = ((AttributeSet)requiredAttributes.get()).subtract(alreadyAdded);
                        output.addAll((Collection<Attribute>)remaining);
                    }
                    if (output.isEmpty()) {
                        Alias alias = new Alias(logicalFragment.source(), "<all-fields-projected>", (Expression)Literal.NULL, null, true);
                        List<Alias> fields = Collections.singletonList(alias);
                        logicalFragment = new Eval(logicalFragment.source(), logicalFragment, fields);
                        output = Expressions.asAttributes(fields);
                    }
                    FragmentExec newChild = new FragmentExec(Source.EMPTY, new Project(logicalFragment.source(), logicalFragment, output), fragmentExec.esFilter(), fragmentExec.estimatedRowSize());
                    return new ExchangeExec(exec.source(), output, exec.inBetweenAggs(), newChild);
                }
            } else {
                AttributeSet childOutput = currentPlanNode.inputSet();
                AttributeSet addedAttributes = currentPlanNode.outputSet().subtract(childOutput);
                requiredAttributes.set((Object)((AttributeSet)requiredAttributes.get()).subtract(addedAttributes).combine(currentPlanNode.references()));
            }
            return currentPlanNode;
        });
    }
}

