/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.logical;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.esql.core.expression.predicate.PredicateBiFunction;
import org.elasticsearch.xpack.esql.core.querydsl.query.BoolQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Check;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;
import org.elasticsearch.xpack.esql.expression.predicate.logical.And;
import org.elasticsearch.xpack.esql.expression.predicate.logical.BinaryLogicOperation;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;

public abstract class BinaryLogic
extends BinaryOperator<Boolean, Boolean, Boolean, BinaryLogicOperation>
implements TranslationAware {
    protected BinaryLogic(Source source, Expression left, Expression right, BinaryLogicOperation operation) {
        super(source, left, right, (PredicateBiFunction)operation);
    }

    protected BinaryLogic(StreamInput in, BinaryLogicOperation op) throws IOException {
        this(Source.readFrom((StreamInput)((StreamInput)((PlanStreamInput)in))), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), op);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.left());
        out.writeNamedWriteable((NamedWriteable)this.right());
    }

    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    protected Expression.TypeResolution resolveInputType(Expression e, TypeResolutions.ParamOrdinal paramOrdinal) {
        return TypeResolutions.isBoolean((Expression)e, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)paramOrdinal);
    }

    public Nullability nullable() {
        return Nullability.UNKNOWN;
    }

    protected boolean isCommutative() {
        return true;
    }

    @Override
    public boolean translatable(LucenePushdownPredicates pushdownPredicates) {
        TranslationAware rightAware;
        TranslationAware leftAware;
        Expression expression = this.left();
        return expression instanceof TranslationAware && (leftAware = (TranslationAware)expression).translatable(pushdownPredicates) && (expression = this.right()) instanceof TranslationAware && (rightAware = (TranslationAware)expression).translatable(pushdownPredicates);
    }

    @Override
    public Query asQuery(TranslatorHandler handler) {
        return BinaryLogic.boolQuery(this.source(), handler.asQuery(this.left()), handler.asQuery(this.right()), this instanceof And);
    }

    public static Query boolQuery(Source source, Query left, Query right, boolean isAnd) {
        BoolQuery bool;
        BoolQuery rightBool;
        BoolQuery leftBool;
        Check.isTrue((left != null || right != null ? 1 : 0) != 0, (String)"Both expressions are null");
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        List queries = left instanceof BoolQuery && (leftBool = (BoolQuery)left).isAnd() == isAnd ? (right instanceof BoolQuery && (rightBool = (BoolQuery)right).isAnd() == isAnd ? CollectionUtils.combine((List)leftBool.queries(), (List)rightBool.queries()) : CollectionUtils.combine((Collection)leftBool.queries(), (Object[])new Query[]{right})) : (right instanceof BoolQuery && (bool = (BoolQuery)right).isAnd() == isAnd ? CollectionUtils.combine((Collection)bool.queries(), (Object[])new Query[]{left}) : Arrays.asList(left, right));
        return new BoolQuery(source, isAnd, queries);
    }
}

