/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.common.geo.BoundingBox;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.index.fielddata.MultiPointValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.field.AbstractScriptFieldFactory;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.Field;

public abstract class PointDocValuesField<T extends SpatialPoint>
extends AbstractScriptFieldFactory<T>
implements Field<T>,
DocValuesScriptFieldFactory,
ScriptDocValues.GeometrySupplier<T, T> {
    protected final MultiPointValues<T> input;
    protected final String name;
    protected T[] values;
    protected int count;
    private final Supplier<T> pointMaker;
    protected final T centroid;
    protected final BoundingBox<T> boundingBox;
    private int labelIndex = 0;

    public PointDocValuesField(MultiPointValues<T> input, String name, Supplier<T> pointMaker, BoundingBox<T> boundingBox, T[] values) {
        this.input = input;
        this.name = name;
        this.pointMaker = pointMaker;
        this.centroid = (SpatialPoint)pointMaker.get();
        this.boundingBox = boundingBox;
        this.values = values;
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        if (this.input.advanceExact(docId)) {
            this.resize(this.input.docValueCount());
            if (this.count == 1) {
                this.setSingleValue();
            } else {
                this.setMultiValue();
            }
        } else {
            this.resize(0);
        }
    }

    private void resize(int newSize) {
        this.count = newSize;
        if (newSize > this.values.length) {
            int oldLength = this.values.length;
            this.values = (SpatialPoint[])ArrayUtil.grow((Object[])this.values, (int)this.count);
            for (int i = oldLength; i < this.values.length; ++i) {
                this.values[i] = (SpatialPoint)this.pointMaker.get();
            }
        }
    }

    protected abstract void resetPointAt(int var1, T var2);

    protected abstract void resetCentroidAndBounds(T var1, T var2, T var3);

    protected abstract double getXFrom(T var1);

    protected abstract double getYFrom(T var1);

    protected abstract T pointOf(double var1, double var3);

    protected abstract double planeDistance(double var1, double var3, T var5);

    private void setSingleValue() throws IOException {
        T point = this.input.nextValue();
        this.resetPointAt(0, point);
        this.resetCentroidAndBounds(point, point, point);
        this.labelIndex = 0;
    }

    private void setMultiValue() throws IOException {
        double centroidY = 0.0;
        double centroidX = 0.0;
        this.labelIndex = 0;
        double maxX = Double.NEGATIVE_INFINITY;
        double minX = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.count; ++i) {
            T point = this.input.nextValue();
            this.resetPointAt(i, point);
            centroidX += this.getXFrom(point);
            centroidY += this.getYFrom(point);
            maxX = Math.max(maxX, this.getXFrom(this.values[i]));
            minX = Math.min(minX, this.getXFrom(this.values[i]));
            maxY = Math.max(maxY, this.getYFrom(this.values[i]));
            minY = Math.min(minY, this.getYFrom(this.values[i]));
            this.labelIndex = this.closestPoint(this.labelIndex, i, (minX + maxX) / 2.0, (minY + maxY) / 2.0);
        }
        this.resetCentroidAndBounds(this.pointOf(centroidX, centroidY), this.pointOf(minX, maxY), this.pointOf(maxX, minY));
    }

    private int closestPoint(int a, int b, double x, double y) {
        double distB;
        if (a == b) {
            return a;
        }
        double distA = this.planeDistance(x, y, this.values[a]);
        return distA < (distB = this.planeDistance(x, y, this.values[b])) ? a : b;
    }

    @Override
    public T getInternal(int index) {
        return this.values[index];
    }

    @Override
    public T getInternalCentroid() {
        return this.centroid;
    }

    @Override
    public BoundingBox<T> getInternalBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public T getInternalLabelPosition() {
        return this.values[this.labelIndex];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    public T get(T defaultValue) {
        return this.get(0, defaultValue);
    }

    public T get(int index, T defaultValue) {
        if (this.isEmpty() || index < 0 || index >= this.count) {
            return defaultValue;
        }
        return this.values[index];
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < PointDocValuesField.this.count;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return PointDocValuesField.this.values[this.index++];
            }
        };
    }
}

