/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.ConstantFieldType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.CoordinatorRewriteContext;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.MultiTermQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class WildcardQueryBuilder
extends AbstractQueryBuilder<WildcardQueryBuilder>
implements MultiTermQueryBuilder {
    public static final String NAME = "wildcard";
    private static final ParseField WILDCARD_FIELD = new ParseField("wildcard", new String[0]);
    private static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    private static final ParseField REWRITE_FIELD = new ParseField("rewrite", new String[0]);
    private final String fieldName;
    private final String value;
    private String rewrite;
    public static final boolean DEFAULT_CASE_INSENSITIVITY = false;
    private static final ParseField CASE_INSENSITIVE_FIELD = new ParseField("case_insensitive", new String[0]);
    private boolean caseInsensitive = false;

    public WildcardQueryBuilder(String fieldName, String value) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.fieldName = fieldName;
        this.value = value;
    }

    public WildcardQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.value = in.readString();
        this.rewrite = in.readOptionalString();
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_7_10_0)) {
            this.caseInsensitive = in.readBoolean();
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeString(this.value);
        out.writeOptionalString(this.rewrite);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_7_10_0)) {
            out.writeBoolean(this.caseInsensitive);
        }
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    public String value() {
        return this.value;
    }

    public WildcardQueryBuilder rewrite(String rewrite) {
        this.rewrite = rewrite;
        return this;
    }

    public String rewrite() {
        return this.rewrite;
    }

    public WildcardQueryBuilder caseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        return this;
    }

    public boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.field(WILDCARD_FIELD.getPreferredName(), this.value);
        if (this.rewrite != null) {
            builder.field(REWRITE_FIELD.getPreferredName(), this.rewrite);
        }
        if (this.caseInsensitive) {
            builder.field(CASE_INSENSITIVE_FIELD.getPreferredName(), this.caseInsensitive);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    public static WildcardQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        String rewrite = null;
        String value = null;
        float boost = 1.0f;
        boolean caseInsensitive = false;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                WildcardQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (WILDCARD_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        value = parser.text();
                        continue;
                    }
                    if (VALUE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        value = parser.text();
                        continue;
                    }
                    if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        boost = parser.floatValue();
                        continue;
                    }
                    if (REWRITE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        rewrite = parser.textOrNull();
                        continue;
                    }
                    if (CASE_INSENSITIVE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        caseInsensitive = parser.booleanValue();
                        continue;
                    }
                    if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        queryName = parser.text();
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[wildcard] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            WildcardQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, parser.currentName());
            fieldName = parser.currentName();
            value = parser.text();
        }
        WildcardQueryBuilder result = (WildcardQueryBuilder)((WildcardQueryBuilder)new WildcardQueryBuilder(fieldName, value).rewrite(rewrite).boost(boost)).queryName(queryName);
        result.caseInsensitive(caseInsensitive);
        return result;
    }

    @Override
    protected QueryBuilder doIndexMetadataRewrite(QueryRewriteContext context) {
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        if (fieldType == null) {
            return new MatchNoneQueryBuilder("The \"" + this.getName() + "\" query is against a field that does not exist");
        }
        return this.maybeRewriteBasedOnConstantFields(fieldType, context);
    }

    @Override
    protected QueryBuilder doCoordinatorRewrite(CoordinatorRewriteContext coordinatorRewriteContext) {
        MappedFieldType fieldType = coordinatorRewriteContext.getFieldType(this.fieldName);
        return this.maybeRewriteBasedOnConstantFields(fieldType, coordinatorRewriteContext);
    }

    private QueryBuilder maybeRewriteBasedOnConstantFields(@Nullable MappedFieldType fieldType, QueryRewriteContext context) {
        if (fieldType instanceof ConstantFieldType) {
            ConstantFieldType constantFieldType = (ConstantFieldType)fieldType;
            Query query = constantFieldType.wildcardQuery(this.value, this.caseInsensitive, context);
            if (query instanceof MatchAllDocsQuery) {
                return new MatchAllQueryBuilder();
            }
            if (query instanceof MatchNoDocsQuery) {
                return new MatchNoneQueryBuilder("The \"" + this.getName() + "\" query was rewritten to a \"match_none\" query.");
            }
            assert (false) : "Constant fields must produce match-all or match-none queries, got " + String.valueOf(query);
        }
        return this;
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        if (fieldType == null) {
            throw new IllegalStateException("Rewrite first");
        }
        MultiTermQuery.RewriteMethod method = QueryParsers.parseRewriteMethod(this.rewrite, null, LoggingDeprecationHandler.INSTANCE);
        return fieldType.wildcardQuery(this.value, method, this.caseInsensitive, context);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.value, this.rewrite, this.caseInsensitive);
    }

    @Override
    protected boolean doEquals(WildcardQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.value, other.value) && Objects.equals(this.rewrite, other.rewrite) && Objects.equals(this.caseInsensitive, other.caseInsensitive);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }
}

