/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.unit;

import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.monitor.jvm.JvmInfo;

public final class MemorySizeValue
extends Enum<MemorySizeValue> {
    private static final /* synthetic */ MemorySizeValue[] $VALUES;

    public static MemorySizeValue[] values() {
        return (MemorySizeValue[])$VALUES.clone();
    }

    public static MemorySizeValue valueOf(String name) {
        return Enum.valueOf(MemorySizeValue.class, name);
    }

    public static ByteSizeValue parseBytesSizeValueOrHeapRatio(String sValue, String settingName) {
        settingName = Objects.requireNonNull(settingName);
        if (sValue != null && sValue.endsWith("%")) {
            return MemorySizeValue.parseHeapRatio(sValue, settingName, 0.0);
        }
        return ByteSizeValue.parseBytesSizeValue(sValue, settingName);
    }

    public static ByteSizeValue parseHeapRatioOrDeprecatedByteSizeValue(String sValue, String settingName, double minHeapPercent) {
        settingName = Objects.requireNonNull(settingName);
        if (sValue != null && sValue.endsWith("%")) {
            return MemorySizeValue.parseHeapRatio(sValue, settingName, minHeapPercent);
        }
        DeprecationLogger.getLogger(BalancedShardsAllocator.class).critical(DeprecationCategory.SETTINGS, "absolute_size_not_supported", "[{}] should be specified using a percentage of the heap. Absolute size settings will be forbidden in a future release", settingName);
        return ByteSizeValue.parseBytesSizeValue(sValue, settingName);
    }

    private static ByteSizeValue parseHeapRatio(String sValue, String settingName, double minHeapPercent) {
        String percentAsString = sValue.substring(0, sValue.length() - 1);
        try {
            double percent = Double.parseDouble(percentAsString);
            if (percent < 0.0 || percent > 100.0) {
                throw new ElasticsearchParseException("percentage should be in [0-100], got [{}]", percentAsString);
            }
            if (percent < minHeapPercent) {
                DeprecationLogger.getLogger(MemorySizeValue.class).critical(DeprecationCategory.SETTINGS, "memory_size_below_minimum", "[{}] setting of [{}] is below the minimum of {}% of the heap", settingName, sValue, minHeapPercent);
            }
            return ByteSizeValue.ofBytes((long)(percent / 100.0 * (double)JvmInfo.jvmInfo().getMem().getHeapMax().getBytes()));
        }
        catch (NumberFormatException e) {
            throw new ElasticsearchParseException("failed to parse [{}] as a double", (Throwable)e, percentAsString);
        }
    }

    private static /* synthetic */ MemorySizeValue[] $values() {
        return new MemorySizeValue[0];
    }

    static {
        $VALUES = MemorySizeValue.$values();
    }
}

