/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.privilege;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;

public final class GetPrivilegesResponse
extends ActionResponse {
    private final ApplicationPrivilegeDescriptor[] privileges;

    public GetPrivilegesResponse(ApplicationPrivilegeDescriptor ... privileges) {
        this.privileges = Objects.requireNonNull(privileges, "Application privileges cannot be null");
    }

    public GetPrivilegesResponse(Collection<ApplicationPrivilegeDescriptor> privileges) {
        this(privileges.toArray(new ApplicationPrivilegeDescriptor[0]));
    }

    public GetPrivilegesResponse(StreamInput in) throws IOException {
        super(in);
        this.privileges = (ApplicationPrivilegeDescriptor[])in.readArray(ApplicationPrivilegeDescriptor::new, ApplicationPrivilegeDescriptor[]::new);
    }

    public ApplicationPrivilegeDescriptor[] privileges() {
        return this.privileges;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray((Writeable[])this.privileges);
    }

    public boolean isEmpty() {
        return this.privileges.length == 0;
    }
}

