/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NerConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TokenizationConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.VocabularyConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public class NerConfig
implements NlpConfig {
    public static final String NAME = "ner";
    private static final ConstructingObjectParser<NerConfig, Void> STRICT_PARSER = NerConfig.createParser(false);
    private static final ConstructingObjectParser<NerConfig, Void> LENIENT_PARSER = NerConfig.createParser(true);
    private final VocabularyConfig vocabularyConfig;
    private final Tokenization tokenization;
    private final List<String> classificationLabels;
    private final String resultsField;

    public static boolean validIOBTag(String label) {
        return label.toUpperCase(Locale.ROOT).startsWith("I-") || label.toUpperCase(Locale.ROOT).startsWith("B-") || label.toUpperCase(Locale.ROOT).startsWith("I_") || label.toUpperCase(Locale.ROOT).startsWith("B_") || label.toUpperCase(Locale.ROOT).startsWith("O");
    }

    public static NerConfig fromXContentStrict(XContentParser parser) {
        return (NerConfig)STRICT_PARSER.apply(parser, null);
    }

    public static NerConfig fromXContentLenient(XContentParser parser) {
        return (NerConfig)LENIENT_PARSER.apply(parser, null);
    }

    private static ConstructingObjectParser<NerConfig, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, ignoreUnknownFields, a -> new NerConfig((VocabularyConfig)a[0], (Tokenization)a[1], (List)a[2], (String)a[3]));
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            if (!ignoreUnknownFields) {
                throw ExceptionsHelper.badRequestException("illegal setting [{}] on inference model creation", VOCABULARY.getPreferredName());
            }
            return VocabularyConfig.fromXContentLenient(p);
        }, VOCABULARY);
        parser.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> (Tokenization)p.namedObject(Tokenization.class, n, (Object)ignoreUnknownFields), TOKENIZATION);
        parser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), CLASSIFICATION_LABELS);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), RESULTS_FIELD);
        return parser;
    }

    public NerConfig(@Nullable VocabularyConfig vocabularyConfig, @Nullable Tokenization tokenization, @Nullable List<String> classificationLabels, @Nullable String resultsField) {
        this.vocabularyConfig = Optional.ofNullable(vocabularyConfig).orElse(new VocabularyConfig(InferenceIndexConstants.nativeDefinitionStore()));
        this.tokenization = tokenization == null ? Tokenization.createDefault() : tokenization;
        List<Object> list = this.classificationLabels = classificationLabels == null ? Collections.emptyList() : classificationLabels;
        if (!this.classificationLabels.isEmpty()) {
            List<String> badLabels = this.classificationLabels.stream().filter(l -> !NerConfig.validIOBTag(l)).toList();
            if (!badLabels.isEmpty()) {
                throw ExceptionsHelper.badRequestException("[{}] only allows IOB tokenization tagging for classification labels; provided {}", NAME, badLabels);
            }
            if (this.classificationLabels.stream().noneMatch(l -> l.toUpperCase(Locale.ROOT).equals("O"))) {
                throw ExceptionsHelper.badRequestException("[{}] only allows IOB tokenization tagging for classification labels; missing outside label [O]", NAME);
            }
        }
        this.resultsField = resultsField;
        if (this.tokenization.span != -1) {
            throw ExceptionsHelper.badRequestException("[{}] does not support windowing long text sequences; configured span [{}]", NAME, this.tokenization.span);
        }
    }

    public NerConfig(StreamInput in) throws IOException {
        this.vocabularyConfig = new VocabularyConfig(in);
        this.tokenization = (Tokenization)in.readNamedWriteable(Tokenization.class);
        this.classificationLabels = in.readStringCollectionAsList();
        this.resultsField = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.vocabularyConfig.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.tokenization);
        out.writeStringCollection(this.classificationLabels);
        out.writeOptionalString(this.resultsField);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(VOCABULARY.getPreferredName(), (ToXContent)this.vocabularyConfig, params);
        NamedXContentObjectHelper.writeNamedObject(builder, params, TOKENIZATION.getPreferredName(), this.tokenization);
        if (!this.classificationLabels.isEmpty()) {
            builder.field(CLASSIFICATION_LABELS.getPreferredName(), this.classificationLabels);
        }
        if (this.resultsField != null) {
            builder.field(RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public boolean isTargetTypeSupported(TargetType targetType) {
        return false;
    }

    @Override
    public InferenceConfig apply(InferenceConfigUpdate update) {
        if (update instanceof NerConfigUpdate) {
            NerConfigUpdate configUpdate = (NerConfigUpdate)update;
            return new NerConfig(this.vocabularyConfig, configUpdate.getTokenizationUpdate() == null ? this.tokenization : configUpdate.getTokenizationUpdate().apply(this.tokenization), this.classificationLabels, Optional.ofNullable(update.getResultsField()).orElse(this.resultsField));
        }
        if (update instanceof TokenizationConfigUpdate) {
            TokenizationConfigUpdate tokenizationUpdate = (TokenizationConfigUpdate)update;
            Tokenization updatedTokenization = this.getTokenization().updateWindowSettings(tokenizationUpdate.getSpanSettings());
            return new NerConfig(this.vocabularyConfig, updatedTokenization, this.classificationLabels, this.resultsField);
        }
        throw this.incompatibleUpdateException(update.getName());
    }

    @Override
    public MlConfigVersion getMinimalSupportedMlConfigVersion() {
        return MlConfigVersion.V_8_0_0;
    }

    @Override
    public TransportVersion getMinimalSupportedTransportVersion() {
        return TransportVersions.V_8_0_0;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NerConfig that = (NerConfig)o;
        return Objects.equals(this.vocabularyConfig, that.vocabularyConfig) && Objects.equals(this.tokenization, that.tokenization) && Objects.equals(this.classificationLabels, that.classificationLabels) && Objects.equals(this.resultsField, that.resultsField);
    }

    public int hashCode() {
        return Objects.hash(this.vocabularyConfig, this.tokenization, this.classificationLabels, this.resultsField);
    }

    @Override
    public VocabularyConfig getVocabularyConfig() {
        return this.vocabularyConfig;
    }

    @Override
    public Tokenization getTokenization() {
        return this.tokenization;
    }

    public List<String> getClassificationLabels() {
        return this.classificationLabels;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public boolean isAllocateOnly() {
        return true;
    }
}

