/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy.entitlements;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.elasticsearch.core.Strings;
import org.elasticsearch.entitlement.runtime.policy.ExternalEntitlement;
import org.elasticsearch.entitlement.runtime.policy.FileUtils;
import org.elasticsearch.entitlement.runtime.policy.PathLookup;
import org.elasticsearch.entitlement.runtime.policy.Platform;
import org.elasticsearch.entitlement.runtime.policy.PolicyValidationException;
import org.elasticsearch.entitlement.runtime.policy.entitlements.Entitlement;

public record FilesEntitlement(List<FileData> filesData) implements Entitlement
{
    public static final String SEPARATOR = FileSystems.getDefault().getSeparator();
    public static final FilesEntitlement EMPTY = new FilesEntitlement(List.of());

    private static Mode parseMode(String mode) {
        if (mode.equals("read")) {
            return Mode.READ;
        }
        if (mode.equals("read_write")) {
            return Mode.READ_WRITE;
        }
        throw new PolicyValidationException("invalid mode: " + mode + ", valid values: [read, read_write]");
    }

    private static Platform parsePlatform(String platform) {
        if (platform.equals("linux")) {
            return Platform.LINUX;
        }
        if (platform.equals("macos")) {
            return Platform.MACOS;
        }
        if (platform.equals("windows")) {
            return Platform.WINDOWS;
        }
        throw new PolicyValidationException("invalid platform: " + platform + ", valid values: [linux, macos, windows]");
    }

    private static PathLookup.BaseDir parseBaseDir(String baseDir) {
        return switch (baseDir) {
            case "config" -> PathLookup.BaseDir.CONFIG;
            case "data" -> PathLookup.BaseDir.DATA;
            case "home" -> PathLookup.BaseDir.USER_HOME;
            case "shared_data" -> PathLookup.BaseDir.SHARED_DATA;
            case "shared_repo" -> PathLookup.BaseDir.SHARED_REPO;
            default -> throw new PolicyValidationException("invalid relative directory: " + baseDir + ", valid values: [config, data, home]");
        };
    }

    @ExternalEntitlement(parameterNames={"paths"}, esModulesOnly=false)
    public static FilesEntitlement build(List<Object> paths) {
        if (paths == null || paths.isEmpty()) {
            throw new PolicyValidationException("must specify at least one path");
        }
        BiFunction<Map, String, String> checkString = (values, key) -> {
            Object value = values.remove(key);
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                String str = (String)value;
                return str;
            }
            throw new PolicyValidationException("expected [" + key + "] to be type [" + String.class.getSimpleName() + "] but found type [" + value.getClass().getSimpleName() + "]");
        };
        BiFunction<Map, String, Boolean> checkBoolean = (values, key) -> {
            Object value = values.remove(key);
            if (value == null) {
                return null;
            }
            if (value instanceof Boolean) {
                Boolean bool = (Boolean)value;
                return bool;
            }
            throw new PolicyValidationException("expected [" + key + "] to be type [" + Boolean.TYPE.getSimpleName() + "] but found type [" + value.getClass().getSimpleName() + "]");
        };
        ArrayList<FileData> filesData = new ArrayList<FileData>();
        for (Object object : paths) {
            FileData fileData;
            boolean exclusive;
            HashMap file = new HashMap((Map)object);
            String pathAsString = checkString.apply(file, "path");
            String relativePathAsString = checkString.apply(file, "relative_path");
            String relativeTo = checkString.apply(file, "relative_to");
            String pathSetting = checkString.apply(file, "path_setting");
            String settingBaseDirAsString = checkString.apply(file, "basedir_if_relative");
            String modeAsString = checkString.apply(file, "mode");
            String platformAsString = checkString.apply(file, "platform");
            Boolean exclusiveBoolean = checkBoolean.apply(file, "exclusive");
            boolean bl = exclusive = exclusiveBoolean != null && exclusiveBoolean != false;
            if (!file.isEmpty()) {
                throw new PolicyValidationException("unknown key(s) [" + String.valueOf(file) + "] in a listed file for files entitlement");
            }
            int foundKeys = (pathAsString != null ? 1 : 0) + (relativePathAsString != null ? 1 : 0) + (pathSetting != null ? 1 : 0);
            if (foundKeys != 1) {
                throw new PolicyValidationException("a files entitlement entry must contain one of [path, relative_path, path_setting]");
            }
            if (modeAsString == null) {
                throw new PolicyValidationException("files entitlement must contain 'mode' for every listed file");
            }
            Mode mode = FilesEntitlement.parseMode(modeAsString);
            Platform platform = null;
            if (platformAsString != null) {
                platform = FilesEntitlement.parsePlatform(platformAsString);
            }
            if (relativeTo != null && relativePathAsString == null) {
                throw new PolicyValidationException("'relative_to' may only be used with 'relative_path'");
            }
            if (settingBaseDirAsString != null && pathSetting == null) {
                throw new PolicyValidationException("'basedir_if_relative' may only be used with 'path_setting'");
            }
            if (relativePathAsString != null) {
                if (relativeTo == null) {
                    throw new PolicyValidationException("files entitlement with a 'relative_path' must specify 'relative_to'");
                }
                baseDir = FilesEntitlement.parseBaseDir(relativeTo);
                Path relativePath = Path.of(relativePathAsString, new String[0]);
                if (FileUtils.isAbsolutePath(relativePathAsString)) {
                    throw new PolicyValidationException("'relative_path' [" + relativePathAsString + "] must be relative");
                }
                fileData = FileData.ofRelativePath(relativePath, baseDir, mode);
            } else if (pathAsString != null) {
                Path path = Path.of(pathAsString, new String[0]);
                if (!FileUtils.isAbsolutePath(pathAsString)) {
                    throw new PolicyValidationException("'path' [" + pathAsString + "] must be absolute");
                }
                fileData = FileData.ofPath(path, mode);
            } else if (pathSetting != null) {
                if (settingBaseDirAsString == null) {
                    throw new PolicyValidationException("files entitlement with a 'path_setting' must specify 'basedir_if_relative'");
                }
                baseDir = FilesEntitlement.parseBaseDir(settingBaseDirAsString);
                fileData = FileData.ofPathSetting(pathSetting, baseDir, mode);
            } else {
                throw new AssertionError((Object)"File entry validation error");
            }
            filesData.add(fileData.withPlatform(platform).withExclusive(exclusive));
        }
        return new FilesEntitlement(filesData);
    }

    public static enum Mode {
        READ,
        READ_WRITE;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface FileData {
        public Stream<Path> resolvePaths(PathLookup var1);

        public Mode mode();

        public boolean exclusive();

        public FileData withExclusive(boolean var1);

        public Platform platform();

        public FileData withPlatform(Platform var1);

        public String description();

        public static FileData ofPath(Path path, Mode mode) {
            return new AbsolutePathFileData(path, mode, null, false);
        }

        public static FileData ofBaseDirPath(PathLookup.BaseDir baseDir, Mode mode) {
            return new RelativePathFileData(Path.of("", new String[0]), baseDir, mode, null, false);
        }

        public static FileData ofRelativePath(Path relativePath, PathLookup.BaseDir baseDir, Mode mode) {
            return new RelativePathFileData(relativePath, baseDir, mode, null, false);
        }

        public static FileData ofPathSetting(String setting, PathLookup.BaseDir baseDir, Mode mode) {
            return new PathSettingFileData(setting, baseDir, mode, null, false);
        }
    }

    private record PathSettingFileData(String setting, PathLookup.BaseDir baseDir, Mode mode, Platform platform, boolean exclusive) implements FileData
    {
        @Override
        public PathSettingFileData withExclusive(boolean exclusive) {
            return new PathSettingFileData(this.setting, this.baseDir, this.mode, this.platform, exclusive);
        }

        @Override
        public FileData withPlatform(Platform platform) {
            if (platform == this.platform()) {
                return this;
            }
            return new PathSettingFileData(this.setting, this.baseDir, this.mode, platform, this.exclusive);
        }

        @Override
        public Stream<Path> resolvePaths(PathLookup pathLookup) {
            return pathLookup.resolveSettingPaths(this.baseDir, this.setting);
        }

        @Override
        public String description() {
            return Strings.format((String)"[%s] <%s>%s<%s>%s", (Object[])new Object[]{this.mode, this.baseDir, SEPARATOR, this.setting, this.exclusive ? " (exclusive)" : ""});
        }
    }

    private record RelativePathFileData(Path relativePath, PathLookup.BaseDir baseDir, Mode mode, Platform platform, boolean exclusive) implements FileData
    {
        @Override
        public RelativePathFileData withExclusive(boolean exclusive) {
            return new RelativePathFileData(this.relativePath, this.baseDir, this.mode, this.platform, exclusive);
        }

        @Override
        public FileData withPlatform(Platform platform) {
            if (platform == this.platform()) {
                return this;
            }
            return new RelativePathFileData(this.relativePath, this.baseDir, this.mode, platform, this.exclusive);
        }

        @Override
        public Stream<Path> resolvePaths(PathLookup pathLookup) {
            return pathLookup.resolveRelativePaths(this.baseDir, this.relativePath);
        }

        @Override
        public String description() {
            return Strings.format((String)"[%s] <%s>%s%s%s", (Object[])new Object[]{this.mode, this.baseDir, SEPARATOR, this.relativePath, this.exclusive ? " (exclusive)" : ""});
        }
    }

    private record AbsolutePathFileData(Path path, Mode mode, Platform platform, boolean exclusive) implements FileData
    {
        @Override
        public AbsolutePathFileData withExclusive(boolean exclusive) {
            return new AbsolutePathFileData(this.path, this.mode, this.platform, exclusive);
        }

        @Override
        public FileData withPlatform(Platform platform) {
            if (platform == this.platform()) {
                return this;
            }
            return new AbsolutePathFileData(this.path, this.mode, platform, this.exclusive);
        }

        @Override
        public Stream<Path> resolvePaths(PathLookup pathLookup) {
            return Stream.of(this.path);
        }

        @Override
        public String description() {
            return Strings.format((String)"[%s] %s%s", (Object[])new Object[]{this.mode, this.path.toAbsolutePath().normalize(), this.exclusive ? " (exclusive)" : ""});
        }
    }
}

