/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.initialization;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.entitlement.bootstrap.EntitlementBootstrap;
import org.elasticsearch.entitlement.bridge.EntitlementChecker;
import org.elasticsearch.entitlement.initialization.DynamicInstrumentation;
import org.elasticsearch.entitlement.initialization.FilesEntitlementsValidation;
import org.elasticsearch.entitlement.initialization.HardcodedEntitlements;
import org.elasticsearch.entitlement.runtime.api.ElasticsearchEntitlementChecker;
import org.elasticsearch.entitlement.runtime.policy.PathLookup;
import org.elasticsearch.entitlement.runtime.policy.Policy;
import org.elasticsearch.entitlement.runtime.policy.PolicyManager;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class EntitlementInitialization {
    private static final Logger logger = LogManager.getLogger(EntitlementInitialization.class);
    private static final Module ENTITLEMENTS_MODULE = PolicyManager.class.getModule();
    private static ElasticsearchEntitlementChecker manager;
    private static AtomicReference<RuntimeException> error;

    public static EntitlementChecker checker() {
        return manager;
    }

    public static RuntimeException getError() {
        return error.get();
    }

    public static void initialize(Instrumentation inst) {
        try {
            manager = EntitlementInitialization.initChecker();
            boolean verifyBytecode = Booleans.parseBoolean((String)System.getProperty("es.entitlements.verify_bytecode", "false"));
            if (verifyBytecode) {
                EntitlementInitialization.ensureClassesSensitiveToVerificationAreInitialized();
            }
            DynamicInstrumentation.initialize(inst, EntitlementInitialization.getVersionSpecificCheckerClass(EntitlementChecker.class, Runtime.version().feature()), verifyBytecode);
        }
        catch (Exception e) {
            error.set(new RuntimeException("Failed to initialize entitlements", e));
        }
    }

    private static PolicyManager createPolicyManager() {
        EntitlementBootstrap.BootstrapArgs bootstrapArgs = EntitlementBootstrap.bootstrapArgs();
        Map<String, Policy> pluginPolicies = bootstrapArgs.pluginPolicies();
        PathLookup pathLookup = bootstrapArgs.pathLookup();
        FilesEntitlementsValidation.validate(pluginPolicies, pathLookup);
        return new PolicyManager(HardcodedEntitlements.serverPolicy(pathLookup.pidFile(), bootstrapArgs.serverPolicyPatch()), HardcodedEntitlements.agentEntitlements(), pluginPolicies, EntitlementBootstrap.bootstrapArgs().scopeResolver(), EntitlementBootstrap.bootstrapArgs().sourcePaths(), ENTITLEMENTS_MODULE, pathLookup, bootstrapArgs.suppressFailureLogPackages());
    }

    private static void ensureClassesSensitiveToVerificationAreInitialized() {
        Set<String> classesToInitialize = Set.of("sun.net.www.protocol.http.HttpURLConnection", "sun.nio.ch.SocketChannelImpl", "java.net.ProxySelector");
        for (String className : classesToInitialize) {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException unexpected) {
                throw new AssertionError((Object)unexpected);
            }
        }
    }

    static Class<?> getVersionSpecificCheckerClass(Class<?> baseClass, int javaVersion) {
        Class<?> clazz;
        String packageName = baseClass.getPackageName();
        String baseClassName = baseClass.getSimpleName();
        Object classNamePrefix = javaVersion < 19 ? "" : (javaVersion < 23 ? "Java" + javaVersion : "Java23");
        String className = packageName + "." + (String)classNamePrefix + baseClassName;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError("entitlement lib cannot find entitlement class " + className, e);
        }
        return clazz;
    }

    private static ElasticsearchEntitlementChecker initChecker() {
        Constructor<?> constructor;
        PolicyManager policyManager = EntitlementInitialization.createPolicyManager();
        Class<?> clazz = EntitlementInitialization.getVersionSpecificCheckerClass(ElasticsearchEntitlementChecker.class, Runtime.version().feature());
        try {
            constructor = clazz.getConstructor(PolicyManager.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError("entitlement impl is missing no arg constructor", e);
        }
        try {
            return (ElasticsearchEntitlementChecker)constructor.newInstance(policyManager);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        error = new AtomicReference();
    }
}

