/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.ShadingStore;
import org.ojalgo.scalar.Scalar;

final class UpperHessenbergStore<N extends Comparable<N>>
extends ShadingStore<N> {
    UpperHessenbergStore(MatrixStore<N> base) {
        super(base);
    }

    @Override
    public double doubleValue(long row, long col) {
        if (row > col + 1L) {
            return PrimitiveMath.ZERO;
        }
        return this.base().doubleValue(row, col);
    }

    @Override
    public int firstInRow(int row) {
        if (row == 0) {
            return 0;
        }
        return row - 1;
    }

    @Override
    public N get(long row, long col) {
        if (row > col + 1L) {
            return (N)((Comparable)this.zero().get());
        }
        return this.base().get(row, col);
    }

    @Override
    public int limitOfColumn(int col) {
        return Math.min(col + 2, this.getRowDim());
    }

    @Override
    public Scalar<N> toScalar(long row, long col) {
        if (row > col + 1L) {
            return this.zero();
        }
        return this.base().toScalar(row, col);
    }
}

