/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.gen.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.gen.script.Agg;
import org.elasticsearch.xpack.ql.expression.gen.script.Grouping;
import org.elasticsearch.xpack.ql.expression.gen.script.Param;
import org.elasticsearch.xpack.ql.expression.gen.script.Script;
import org.elasticsearch.xpack.ql.expression.gen.script.Var;

public class Params {
    public static final Params EMPTY = new Params(Collections.emptyList());
    private final List<Param<?>> params;

    Params(List<Param<?>> params) {
        this.params = Params.flatten(params);
    }

    List<String> asCodeNames() {
        if (this.params.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(this.params.size());
        int aggs = 0;
        int vars = 0;
        for (Param<?> p : this.params) {
            names.add(p.prefix() + (p instanceof Agg ? aggs++ : vars++));
        }
        return names;
    }

    Map<String, Object> asParams() {
        LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)this.params.size());
        int count = 0;
        for (Param<?> p : this.params) {
            if (!(p instanceof Var)) continue;
            map.put(p.prefix() + count++, p.value());
        }
        return map;
    }

    Map<String, String> asAggPaths() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int aggs = 0;
        for (Param<?> p : this.params) {
            if (p instanceof Agg) {
                Agg a = (Agg)p;
                String s = a.aggProperty() != null ? a.aggProperty() : a.aggName();
                map.put(p.prefix() + aggs++, s);
            }
            if (!(p instanceof Grouping)) continue;
            Grouping g = (Grouping)p;
            map.put(p.prefix() + aggs++, g.groupName());
        }
        return map;
    }

    private static List<Param<?>> flatten(List<Param<?>> params) {
        List<Param<?>> flatten = Collections.emptyList();
        if (!params.isEmpty()) {
            flatten = new ArrayList();
            for (Param<?> p : params) {
                if (p instanceof Script) {
                    flatten.addAll(Params.flatten(((Params)((Script)p).value()).params));
                    continue;
                }
                if (p instanceof Agg) {
                    flatten.add(p);
                    continue;
                }
                if (p instanceof Grouping) {
                    flatten.add(p);
                    continue;
                }
                if (p instanceof Var) {
                    flatten.add(p);
                    continue;
                }
                throw new QlIllegalArgumentException("Unsupported field {}", p);
            }
        }
        return flatten;
    }

    public String toString() {
        return this.params.toString();
    }

    public int hashCode() {
        return this.params.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Params)) {
            return false;
        }
        return this.params.equals(((Params)obj).params);
    }
}

