/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.direct;

import java.time.Instant;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.SimpleBatchedExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.ingest.IngestGeoIpFeatures;
import org.elasticsearch.ingest.geoip.IngestGeoIpMetadata;
import org.elasticsearch.ingest.geoip.direct.DatabaseConfiguration;
import org.elasticsearch.ingest.geoip.direct.DatabaseConfigurationMetadata;
import org.elasticsearch.ingest.geoip.direct.PutDatabaseConfigurationAction;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutDatabaseConfigurationAction
extends TransportMasterNodeAction<PutDatabaseConfigurationAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportPutDatabaseConfigurationAction.class);
    private static final SimpleBatchedExecutor<UpdateDatabaseConfigurationTask, Void> UPDATE_TASK_EXECUTOR = new SimpleBatchedExecutor<UpdateDatabaseConfigurationTask, Void>(){

        public Tuple<ClusterState, Void> executeTask(UpdateDatabaseConfigurationTask task, ClusterState clusterState) throws Exception {
            return Tuple.tuple((Object)task.execute(clusterState), null);
        }

        public void taskSucceeded(UpdateDatabaseConfigurationTask task, Void unused) {
            logger.trace("Updated cluster state for creation-or-update of database configuration [{}]", (Object)task.database.id());
            task.listener.onResponse((Object)AcknowledgedResponse.TRUE);
        }
    };
    private final FeatureService featureService;
    private final MasterServiceTaskQueue<UpdateDatabaseConfigurationTask> updateDatabaseConfigurationTaskQueue;

    @Inject
    public TransportPutDatabaseConfigurationAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, FeatureService featureService) {
        super("cluster:admin/ingest/geoip/database/put", transportService, clusterService, threadPool, actionFilters, PutDatabaseConfigurationAction.Request::new, AcknowledgedResponse::readFrom, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.featureService = featureService;
        this.updateDatabaseConfigurationTaskQueue = clusterService.createTaskQueue("update-geoip-database-configuration-state-update", Priority.NORMAL, UPDATE_TASK_EXECUTOR);
    }

    protected void masterOperation(Task task, PutDatabaseConfigurationAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        String id = request.getDatabase().id();
        if (request.getDatabase().provider() instanceof DatabaseConfiguration.Ipinfo && !this.featureService.clusterHasFeature(this.clusterService.state(), IngestGeoIpFeatures.PUT_DATABASE_CONFIGURATION_ACTION_IPINFO)) {
            listener.onFailure((Exception)new IllegalArgumentException("Unable to use ipinfo database configurations in mixed-clusters with nodes that do not support feature " + IngestGeoIpFeatures.PUT_DATABASE_CONFIGURATION_ACTION_IPINFO.id()));
            return;
        }
        this.updateDatabaseConfigurationTaskQueue.submitTask(Strings.format((String)"update-geoip-database-configuration-[%s]", (Object[])new Object[]{id}), (ClusterStateTaskListener)new UpdateDatabaseConfigurationTask(listener, request.getDatabase()), null);
    }

    static boolean isNoopUpdate(@Nullable DatabaseConfigurationMetadata existingDatabase, DatabaseConfiguration newDatabase) {
        if (existingDatabase == null) {
            return false;
        }
        return newDatabase.equals(existingDatabase.database());
    }

    static void validatePrerequisites(DatabaseConfiguration database, ClusterState state) {
        IngestGeoIpMetadata geoIpMeta = (IngestGeoIpMetadata)state.metadata().custom("ingest_geoip", (Metadata.Custom)IngestGeoIpMetadata.EMPTY);
        Optional<DatabaseConfiguration> sameName = geoIpMeta.getDatabases().values().stream().map(DatabaseConfigurationMetadata::database).filter(d -> !d.id().equals(database.id())).filter(d -> d.name().equals(database.name())).findFirst();
        sameName.ifPresent(d -> {
            throw new IllegalArgumentException(Strings.format((String)"database [%s] is already being downloaded via configuration [%s]", (Object[])new Object[]{database.name(), d.id()}));
        });
    }

    protected ClusterBlockException checkBlock(PutDatabaseConfigurationAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private record UpdateDatabaseConfigurationTask(ActionListener<AcknowledgedResponse> listener, DatabaseConfiguration database) implements ClusterStateTaskListener
    {
        ClusterState execute(ClusterState currentState) throws Exception {
            IngestGeoIpMetadata geoIpMeta = (IngestGeoIpMetadata)currentState.metadata().custom("ingest_geoip", (Metadata.Custom)IngestGeoIpMetadata.EMPTY);
            String id = this.database.id();
            DatabaseConfigurationMetadata existingDatabase = geoIpMeta.getDatabases().get(id);
            if (TransportPutDatabaseConfigurationAction.isNoopUpdate(existingDatabase, this.database)) {
                return currentState;
            }
            TransportPutDatabaseConfigurationAction.validatePrerequisites(this.database, currentState);
            HashMap<String, DatabaseConfigurationMetadata> databases = new HashMap<String, DatabaseConfigurationMetadata>(geoIpMeta.getDatabases());
            databases.put(id, new DatabaseConfigurationMetadata(this.database, existingDatabase == null ? 1L : existingDatabase.version() + 1L, Instant.now().toEpochMilli()));
            geoIpMeta = new IngestGeoIpMetadata(databases);
            if (existingDatabase == null) {
                logger.debug("adding new database configuration [{}]", (Object)id);
            } else {
                logger.debug("updating existing database configuration [{}]", (Object)id);
            }
            Metadata currentMeta = currentState.metadata();
            return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentMeta).putCustom("ingest_geoip", (Metadata.Custom)geoIpMeta)).build();
        }

        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }
}

