/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.monitoring.action.MonitoringMigrateAlertsRequest;
import org.elasticsearch.xpack.core.monitoring.action.MonitoringMigrateAlertsResponse;
import org.elasticsearch.xpack.monitoring.Monitoring;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;
import org.elasticsearch.xpack.monitoring.exporter.Exporters;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringMigrationCoordinator;

public class TransportMonitoringMigrateAlertsAction
extends TransportMasterNodeAction<MonitoringMigrateAlertsRequest, MonitoringMigrateAlertsResponse> {
    private static final Logger logger = LogManager.getLogger(TransportMonitoringMigrateAlertsAction.class);
    private final Client client;
    private final MonitoringMigrationCoordinator migrationCoordinator;
    private final Exporters exporters;

    @Inject
    public TransportMonitoringMigrateAlertsAction(Client client, Exporters exporters, MonitoringMigrationCoordinator migrationCoordinator, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/xpack/monitoring/migrate/alerts", transportService, clusterService, threadPool, actionFilters, MonitoringMigrateAlertsRequest::new, MonitoringMigrateAlertsResponse::new, (Executor)threadPool.executor("management"));
        this.client = client;
        this.migrationCoordinator = migrationCoordinator;
        this.exporters = exporters;
    }

    protected void masterOperation(Task task, MonitoringMigrateAlertsRequest request, ClusterState state, ActionListener<MonitoringMigrateAlertsResponse> listener) throws Exception {
        if (!this.migrationCoordinator.tryBlockInstallationTasks()) {
            throw new EsRejectedExecutionException("Could not migrate cluster alerts. Migration already in progress.");
        }
        try {
            listener = ActionListener.runBefore(listener, this.migrationCoordinator::unblockInstallationTasks);
            Settings.Builder decommissionAlertSetting = Settings.builder().put(Monitoring.MIGRATION_DECOMMISSION_ALERTS.getKey(), true);
            this.client.admin().cluster().prepareUpdateSettings(request.masterNodeTimeout(), request.masterNodeTimeout()).setPersistentSettings(decommissionAlertSetting).execute(this.completeOnManagementThread((ActionListener<MonitoringMigrateAlertsResponse>)listener));
        }
        catch (Exception e) {
            this.migrationCoordinator.unblockInstallationTasks();
            throw e;
        }
    }

    private ActionListener<ClusterUpdateSettingsResponse> completeOnManagementThread(ActionListener<MonitoringMigrateAlertsResponse> delegate) {
        return delegate.delegateFailure((l, response) -> this.threadPool.executor("management").execute((Runnable)ActionRunnable.wrap((ActionListener)l, listener -> this.afterSettingUpdate((ActionListener<MonitoringMigrateAlertsResponse>)listener, (ClusterUpdateSettingsResponse)response))));
    }

    private void afterSettingUpdate(ActionListener<MonitoringMigrateAlertsResponse> listener, ClusterUpdateSettingsResponse clusterUpdateSettingsResponse) {
        logger.info("THREAD NAME: {}" + Thread.currentThread().getName());
        if (!clusterUpdateSettingsResponse.isAcknowledged()) {
            listener.onFailure((Exception)new ElasticsearchException("Failed to update monitoring migration settings", new Object[0]));
        }
        Collection<Exporter> enabledExporters = this.exporters.getEnabledExporters();
        Collection<Exporter.Config> disabledExporterConfigs = this.exporters.getDisabledExporterConfigs();
        ArrayList<ActionRunnable> refreshTasks = new ArrayList<ActionRunnable>();
        AtomicInteger remaining = new AtomicInteger(enabledExporters.size() + disabledExporterConfigs.size());
        List<Exporter.ExporterResourceStatus> results = Collections.synchronizedList(new ArrayList(remaining.get()));
        logger.debug("Exporters in need of refreshing [{}]; enabled [{}], disabled [{}]", (Object)remaining.get(), (Object)enabledExporters.size(), (Object)disabledExporterConfigs.size());
        for (Exporter exporter : enabledExporters) {
            refreshTasks.add(ActionRunnable.wrap(TransportMonitoringMigrateAlertsAction.resultCollector(exporter.config(), listener, remaining, results), resultCollector -> TransportMonitoringMigrateAlertsAction.deleteAlertsFromOpenExporter(enabledExporter, (ActionListener<Exporter.ExporterResourceStatus>)resultCollector)));
        }
        for (Exporter.Config config : disabledExporterConfigs) {
            refreshTasks.add(ActionRunnable.wrap(TransportMonitoringMigrateAlertsAction.resultCollector(config, listener, remaining, results), resultCollector -> this.deleteAlertsFromDisabledExporter(disabledExporter, (ActionListener<Exporter.ExporterResourceStatus>)resultCollector)));
        }
        for (Runnable runnable : refreshTasks) {
            this.threadPool.executor("management").execute(runnable);
        }
    }

    private static ActionListener<Exporter.ExporterResourceStatus> resultCollector(final Exporter.Config exporterConfig, final ActionListener<MonitoringMigrateAlertsResponse> listener, final AtomicInteger remaining, final List<Exporter.ExporterResourceStatus> results) {
        return new ActionListener<Exporter.ExporterResourceStatus>(){

            public void onResponse(Exporter.ExporterResourceStatus exporterResourceStatus) {
                this.addStatus(exporterResourceStatus);
            }

            public void onFailure(Exception e) {
                this.addStatus(Exporter.ExporterResourceStatus.notReady(exporterConfig.name(), exporterConfig.type(), e));
            }

            private void addStatus(Exporter.ExporterResourceStatus exporterResourceStatus) {
                results.add(exporterResourceStatus);
                int tasksRemaining = remaining.decrementAndGet();
                if (tasksRemaining == 0) {
                    this.finalResult();
                }
            }

            private void finalResult() {
                try {
                    List<MonitoringMigrateAlertsResponse.ExporterMigrationResult> collectedResults = results.stream().map(status -> new MonitoringMigrateAlertsResponse.ExporterMigrationResult(status.getExporterName(), status.getExporterType(), status.isComplete(), 1.compileReason(status))).toList();
                    MonitoringMigrateAlertsResponse response = new MonitoringMigrateAlertsResponse(collectedResults);
                    listener.onResponse((Object)response);
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }

            private static Exception compileReason(Exporter.ExporterResourceStatus status) {
                List<Exception> exceptions = status.getExceptions();
                if (exceptions == null || exceptions.size() == 0) {
                    return null;
                }
                if (exceptions.size() == 1) {
                    return exceptions.get(0);
                }
                ElasticsearchException head = new ElasticsearchException("multiple errors occurred during migration", (Throwable)exceptions.get(0), new Object[0]);
                List<Exception> tail = exceptions.subList(1, exceptions.size());
                return (Exception)tail.stream().reduce(head, ExceptionsHelper::useOrSuppress);
            }
        };
    }

    private static void deleteAlertsFromOpenExporter(Exporter exporter, ActionListener<Exporter.ExporterResourceStatus> listener) {
        assert (exporter.isOpen());
        try {
            exporter.removeAlerts(status -> {
                logger.debug("exporter [{}]: completed setup with status [{}]", (Object)exporter.config().name(), (Object)status.isComplete());
                listener.onResponse(status);
            });
        }
        catch (Exception e) {
            logger.debug("exporter [" + exporter.config().name() + "]: exception encountered during refresh", (Throwable)e);
            listener.onFailure(e);
        }
    }

    private void deleteAlertsFromDisabledExporter(Exporter.Config exporterConf, ActionListener<Exporter.ExporterResourceStatus> listener) {
        Exporter disabledExporter = this.exporters.openExporter(exporterConf);
        TransportMonitoringMigrateAlertsAction.deleteAlertsFromOpenExporter(disabledExporter, (ActionListener<Exporter.ExporterResourceStatus>)ActionListener.runBefore(listener, disabledExporter::close));
    }

    protected ClusterBlockException checkBlock(MonitoringMigrateAlertsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

