/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.response.alibabacloudsearch;

import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.alibabacloudsearch.AlibabaCloudSearchRequest;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;

public abstract class AlibabaCloudSearchResponseEntity {
    private static final Logger logger = LogManager.getLogger(AlibabaCloudSearchResponseEntity.class);

    public static <R> R fromResponse(Request request, HttpResult response, CheckedFunction<XContentParser, R, IOException> function) throws IOException {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        AlibabaCloudSearchRequest alibabaCloudSearchRequest = (AlibabaCloudSearchRequest)request;
        try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, response.body());){
            XContentUtils.moveToFirstToken(parser);
            XContentParser.Token token = parser.currentToken();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
            Object result = null;
            String requestID = null;
            float latency = 0.0f;
            Map usage = null;
            block17: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String currentFieldName = parser.currentName();
                parser.nextToken();
                switch (currentFieldName) {
                    case "result": {
                        result = function.apply((Object)parser);
                        continue block17;
                    }
                    case "request_id": {
                        requestID = parser.text();
                        continue block17;
                    }
                    case "latency": {
                        latency = parser.floatValue();
                        continue block17;
                    }
                    case "usage": {
                        usage = parser.map();
                        continue block17;
                    }
                }
                parser.skipChildren();
            }
            logger.debug("AlibabaCloud Search uri [{}] response: request_id [{}], latency [{}ms], client cost [{}ms], usage [{}]", (Object)request.getURI().getPath(), requestID, (Object)Float.valueOf(latency), (Object)(System.currentTimeMillis() - alibabaCloudSearchRequest.getStartTime()), usage);
            Object object = result;
            return (R)object;
        }
    }
}

