/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit.integrity;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class RepositoryVerifyIntegrityTask
extends CancellableTask {
    private volatile Supplier<Status> statusSupplier;

    public RepositoryVerifyIntegrityTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers) {
        super(id, type, action, description, parentTaskId, headers);
    }

    public void setStatusSupplier(Supplier<Status> statusSupplier) {
        this.statusSupplier = statusSupplier;
    }

    public Status getStatus() {
        return Optional.ofNullable(this.statusSupplier).map(Supplier::get).orElse(null);
    }

    public record Status(String repositoryName, long repositoryGeneration, String repositoryUUID, long snapshotCount, long snapshotsVerified, long indexCount, long indicesVerified, long indexSnapshotCount, long indexSnapshotsVerified, long blobsVerified, long blobBytesVerified, long throttledNanos) implements Task.Status
    {
        public static String NAME = "verify_repository_integrity_status";

        public Status(StreamInput in) throws IOException {
            this(in.readString(), in.readVLong(), in.readString(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.repositoryName);
            out.writeVLong(this.repositoryGeneration);
            out.writeString(this.repositoryUUID);
            out.writeVLong(this.snapshotCount);
            out.writeVLong(this.snapshotsVerified);
            out.writeVLong(this.indexCount);
            out.writeVLong(this.indicesVerified);
            out.writeVLong(this.indexSnapshotCount);
            out.writeVLong(this.indexSnapshotsVerified);
            out.writeVLong(this.blobsVerified);
            out.writeVLong(this.blobBytesVerified);
            out.writeVLong(this.throttledNanos);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startObject("repository");
            builder.field("name", this.repositoryName);
            builder.field("uuid", this.repositoryUUID);
            builder.field("generation", this.repositoryGeneration);
            builder.endObject();
            builder.startObject("snapshots");
            builder.field("verified", this.snapshotsVerified);
            builder.field("total", this.snapshotCount);
            builder.endObject();
            builder.startObject("indices");
            builder.field("verified", this.indicesVerified);
            builder.field("total", this.indexCount);
            builder.endObject();
            builder.startObject("index_snapshots");
            builder.field("verified", this.indexSnapshotsVerified);
            builder.field("total", this.indexSnapshotCount);
            builder.endObject();
            builder.startObject("blobs");
            builder.field("verified", this.blobsVerified);
            if (this.throttledNanos > 0L) {
                builder.humanReadableField("verified_size_in_bytes", "verified_size", (Object)ByteSizeValue.ofBytes((long)this.blobBytesVerified));
                builder.humanReadableField("throttled_time_in_millis", "throttled_time", (Object)TimeValue.timeValueNanos((long)this.throttledNanos));
            }
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public String getWriteableName() {
            return NAME;
        }
    }
}

