/*
 * Decompiled with CFR 0.152.
 */
package com.wdtinc.mapbox_vector_tile.adapt.jts.model;

import com.wdtinc.mapbox_vector_tile.adapt.jts.model.JtsLayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class JtsMvt {
    private final Map<String, JtsLayer> layersByName;

    public JtsMvt() {
        this(Collections.emptyList());
    }

    public JtsMvt(JtsLayer layer) {
        this(Collections.singletonList(layer));
    }

    public JtsMvt(JtsLayer ... layers) {
        this(new ArrayList<JtsLayer>(Arrays.asList(layers)));
    }

    public JtsMvt(Collection<JtsLayer> layers) {
        this.layersByName = new LinkedHashMap<String, JtsLayer>(layers.size());
        for (JtsLayer nextLayer : layers) {
            this.layersByName.put(nextLayer.getName(), nextLayer);
        }
    }

    public JtsLayer getLayer(String name) {
        return this.layersByName.get(name);
    }

    public Map<String, JtsLayer> getLayersByName() {
        return this.layersByName;
    }

    public Collection<JtsLayer> getLayers() {
        return this.layersByName.values();
    }

    public String toString() {
        return "JtsMvt{layersByName=" + this.layersByName + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JtsMvt jtsMvt = (JtsMvt)o;
        return this.layersByName.equals(jtsMvt.layersByName);
    }

    public int hashCode() {
        return this.layersByName.hashCode();
    }
}

