/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.lucene.util.Counter;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.transport.Transports;

public final class InferenceProcessorInfoExtractor {
    private static final String FOREACH_PROCESSOR_NAME = "foreach";
    private static final int MAX_INFERENCE_PROCESSOR_SEARCH_RECURSIONS = 10;

    private InferenceProcessorInfoExtractor() {
    }

    public static int countInferenceProcessors(ClusterState state) {
        Metadata metadata = state.getMetadata();
        if (metadata == null) {
            return 0;
        }
        IngestMetadata ingestMetadata = (IngestMetadata)metadata.custom("ingest");
        if (ingestMetadata == null) {
            return 0;
        }
        Counter counter = Counter.newCounter();
        ingestMetadata.getPipelines().forEach((pipelineId, configuration) -> {
            Map configMap = configuration.getConfig();
            List processorConfigs = (List)configMap.get("processors");
            for (Map processorConfigWithKey : processorConfigs) {
                for (Map.Entry entry : processorConfigWithKey.entrySet()) {
                    InferenceProcessorInfoExtractor.addModelsAndPipelines((String)entry.getKey(), pipelineId, entry.getValue(), pam -> counter.addAndGet(1L), 0);
                }
            }
        });
        return (int)counter.get();
    }

    public static Set<String> getModelIdsFromInferenceProcessors(IngestMetadata ingestMetadata) {
        if (ingestMetadata == null) {
            return Set.of();
        }
        LinkedHashSet<String> modelIds = new LinkedHashSet<String>();
        ingestMetadata.getPipelines().forEach((pipelineId, configuration) -> {
            Map configMap = configuration.getConfig();
            List<Map<String, Object>> processorConfigs = InferenceProcessorInfoExtractor.readList(configMap, "processors");
            for (Map<String, Object> processorConfigWithKey : processorConfigs) {
                for (Map.Entry<String, Object> entry : processorConfigWithKey.entrySet()) {
                    InferenceProcessorInfoExtractor.addModelsAndPipelines(entry.getKey(), pipelineId, entry.getValue(), pam -> modelIds.add(pam.modelIdOrAlias()), 0);
                }
            }
        });
        return modelIds;
    }

    public static Map<String, Set<String>> pipelineIdsByResource(ClusterState state, Set<String> ids) {
        assert (Transports.assertNotTransportThread((String)"non-trivial nested loops over cluster state structures"));
        HashMap<String, Set<String>> pipelineIdsByModelIds = new HashMap<String, Set<String>>();
        Metadata metadata = state.metadata();
        if (metadata == null) {
            return pipelineIdsByModelIds;
        }
        IngestMetadata ingestMetadata = (IngestMetadata)metadata.custom("ingest");
        if (ingestMetadata == null) {
            return pipelineIdsByModelIds;
        }
        ingestMetadata.getPipelines().forEach((pipelineId, configuration) -> {
            Map configMap = configuration.getConfig();
            List<Map<String, Object>> processorConfigs = InferenceProcessorInfoExtractor.readList(configMap, "processors");
            for (Map<String, Object> processorConfigWithKey : processorConfigs) {
                for (Map.Entry<String, Object> entry : processorConfigWithKey.entrySet()) {
                    InferenceProcessorInfoExtractor.addModelsAndPipelines(entry.getKey(), pipelineId, entry.getValue(), pam -> {
                        if (ids.contains(pam.modelIdOrAlias)) {
                            pipelineIdsByModelIds.computeIfAbsent(pam.modelIdOrAlias, m -> new LinkedHashSet()).add(pipelineId);
                        }
                    }, 0);
                }
            }
        });
        return pipelineIdsByModelIds;
    }

    public static Set<String> pipelineIdsForResource(ClusterState state, Set<String> ids) {
        assert (Transports.assertNotTransportThread((String)"non-trivial nested loops over cluster state structures"));
        HashSet<String> pipelineIds = new HashSet<String>();
        Metadata metadata = state.metadata();
        if (metadata == null) {
            return pipelineIds;
        }
        IngestMetadata ingestMetadata = (IngestMetadata)metadata.custom("ingest");
        if (ingestMetadata == null) {
            return pipelineIds;
        }
        ingestMetadata.getPipelines().forEach((pipelineId, configuration) -> {
            Map configMap = configuration.getConfig();
            List<Map<String, Object>> processorConfigs = InferenceProcessorInfoExtractor.readList(configMap, "processors");
            for (Map<String, Object> processorConfigWithKey : processorConfigs) {
                for (Map.Entry<String, Object> entry : processorConfigWithKey.entrySet()) {
                    InferenceProcessorInfoExtractor.addModelsAndPipelines(entry.getKey(), pipelineId, entry.getValue(), pam -> {
                        if (ids.contains(pam.modelIdOrAlias)) {
                            pipelineIds.add((String)pipelineId);
                        }
                    }, 0);
                }
            }
        });
        return pipelineIds;
    }

    private static void addModelsAndPipelines(String processorType, String pipelineId, Object processorDefinition, Consumer<PipelineAndModel> handler, int level) {
        Map definitionMap;
        if (level > 10) {
            return;
        }
        if (processorType == null || processorDefinition == null) {
            return;
        }
        if ("inference".equals(processorType)) {
            Map definitionMap2;
            String modelId;
            if (processorDefinition instanceof Map && (modelId = (String)(definitionMap2 = (Map)processorDefinition).get("model_id")) != null) {
                handler.accept(new PipelineAndModel(pipelineId, modelId));
            }
            return;
        }
        if (FOREACH_PROCESSOR_NAME.equals(processorType) && processorDefinition instanceof Map) {
            Map definitionMap3 = (Map)processorDefinition;
            Map innerProcessor = (Map)definitionMap3.get("processor");
            if (innerProcessor != null) {
                for (Map.Entry innerProcessorWithName : innerProcessor.entrySet()) {
                    InferenceProcessorInfoExtractor.addModelsAndPipelines((String)innerProcessorWithName.getKey(), pipelineId, innerProcessorWithName.getValue(), handler, level + 1);
                }
            }
            return;
        }
        if (processorDefinition instanceof Map && (definitionMap = (Map)processorDefinition).containsKey("on_failure")) {
            List<Map<String, Object>> onFailureConfigs = InferenceProcessorInfoExtractor.readList(definitionMap, "on_failure");
            onFailureConfigs.stream().flatMap(map -> map.entrySet().stream()).forEach(entry -> InferenceProcessorInfoExtractor.addModelsAndPipelines((String)entry.getKey(), pipelineId, entry.getValue(), handler, level + 1));
        }
    }

    private static List<Map<String, Object>> readList(Map<?, ?> processorConfig, String key) {
        Object val = processorConfig.get(key);
        if (val == null) {
            throw new IllegalArgumentException("Missing required property [" + key + "]");
        }
        return (List)val;
    }

    private record PipelineAndModel(String pipelineId, String modelIdOrAlias) {
    }
}

