/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.persistence;

import java.util.Map;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public final class InferenceIndexConstants {
    public static final String INDEX_VERSION = "000005";
    public static final String INDEX_NAME_PREFIX = ".ml-inference-";
    public static final String INDEX_PATTERN = ".ml-inference-*";
    public static final String LATEST_INDEX_NAME = ".ml-inference-000005";
    public static final ParseField DOC_TYPE = new ParseField("doc_type", new String[0]);
    private static final String NATIVE_INDEX_PREFIX = ".ml-inference-native-";
    private static final String NATIVE_INDEX_VERSION = "000002";
    private static final String NATIVE_LATEST_INDEX = ".ml-inference-native-000002";
    private static final String MAPPINGS_VERSION_VARIABLE = "xpack.ml.version";
    public static final int INFERENCE_INDEX_MAPPINGS_VERSION = 3;

    public static String mapping() {
        return TemplateUtils.loadTemplate("/ml/inference_index_mappings.json", "8.11.0", MAPPINGS_VERSION_VARIABLE, Map.of("xpack.ml.managed.index.version", Integer.toString(3)));
    }

    public static String nativeDefinitionStore() {
        return NATIVE_LATEST_INDEX;
    }

    public static Settings settings() {
        return Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1").build();
    }

    private InferenceIndexConstants() {
    }
}

