/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.rest.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.idp.action.SamlMetadataAction;
import org.elasticsearch.xpack.idp.action.SamlMetadataRequest;
import org.elasticsearch.xpack.idp.action.SamlMetadataResponse;
import org.elasticsearch.xpack.idp.saml.rest.action.IdpBaseRestHandler;

public class RestSamlMetadataAction
extends IdpBaseRestHandler {
    public RestSamlMetadataAction(XPackLicenseState licenseState) {
        super(licenseState);
    }

    public String getName() {
        return "saml_metadata_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_idp/saml/metadata/{sp_entity_id}"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String spEntityId = request.param("sp_entity_id");
        String acs = request.param("acs");
        SamlMetadataRequest metadataRequest = new SamlMetadataRequest(spEntityId, acs);
        return channel -> client.execute((ActionType)SamlMetadataAction.INSTANCE, (ActionRequest)metadataRequest, (ActionListener)new RestBuilderListener<SamlMetadataResponse>(channel){

            public RestResponse buildResponse(SamlMetadataResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                builder.field("metadata", response.getXmlString());
                builder.endObject();
                return new RestResponse(RestStatus.OK, builder);
            }
        });
    }
}

