/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIPFromStringEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class ToIP
extends AbstractConvertFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToIP", ToIP::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.IP, (field, source) -> field), Map.entry(DataType.KEYWORD, ToIPFromStringEvaluator.Factory::new), Map.entry(DataType.TEXT, ToIPFromStringEvaluator.Factory::new), Map.entry(DataType.SEMANTIC_TEXT, ToIPFromStringEvaluator.Factory::new));

    @FunctionInfo(returnType={"ip"}, description="Converts an input string to an IP value.", examples={@Example(file="ip", tag="to_ip", explanation="Note that in this example, the last conversion of the string isn't possible.\nWhen this happens, the result is a *null* value. In this case a _Warning_ header is added to the response.\nThe header will provide information on the source of the failure:\n\n`\"Line 1:68: evaluation of [TO_IP(str2)] failed, treating result as null. Only first 20 failures recorded.\"`\n\nA following header will contain the failure reason and the offending value:\n\n`\"java.lang.IllegalArgumentException: 'foo' is not an IP string literal.\"`")})
    public ToIP(Source source, @Param(name="field", type={"ip", "keyword", "text"}, description="Input value. The input can be a single- or multi-valued column or an expression.") Expression field) {
        super(source, field);
    }

    private ToIP(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return ToIP.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataType.IP;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToIP(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToIP::new, (Object)this.field());
    }

    static BytesRef fromKeyword(BytesRef asString) {
        return EsqlDataTypeConverter.stringToIP(asString);
    }
}

