/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDateNanos;

public final class ToDateNanosFromDoubleEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    public ToDateNanosFromDoubleEvaluator(EvalOperator.ExpressionEvaluator field, Source source, DriverContext driverContext) {
        super(driverContext, field, source);
    }

    @Override
    public String name() {
        return "ToDateNanosFromDouble";
    }

    @Override
    public Block evalVector(Vector v) {
        DoubleVector vector = (DoubleVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            try {
                return this.driverContext.blockFactory().newConstantLongBlockWith(ToDateNanosFromDoubleEvaluator.evalValue(vector, 0), positionCount);
            }
            catch (IllegalArgumentException | InvalidArgumentException e) {
                this.registerException((Exception)e);
                return this.driverContext.blockFactory().newConstantNullBlock(positionCount);
            }
        }
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    builder.appendLong(ToDateNanosFromDoubleEvaluator.evalValue(vector, p));
                    continue;
                }
                catch (IllegalArgumentException | InvalidArgumentException e) {
                    this.registerException((Exception)e);
                    builder.appendNull();
                }
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    private static long evalValue(DoubleVector container, int index) {
        double value = container.getDouble(index);
        return ToDateNanos.fromDouble(value);
    }

    @Override
    public Block evalBlock(Block b) {
        DoubleBlock block = (DoubleBlock)b;
        int positionCount = block.getPositionCount();
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    try {
                        long value = ToDateNanosFromDoubleEvaluator.evalValue(block, i);
                        if (!positionOpened && valueCount > 1) {
                            builder.beginPositionEntry();
                            positionOpened = true;
                        }
                        builder.appendLong(value);
                        valuesAppended = true;
                        continue;
                    }
                    catch (IllegalArgumentException | InvalidArgumentException e) {
                        this.registerException((Exception)e);
                    }
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    private static long evalValue(DoubleBlock container, int index) {
        double value = container.getDouble(index);
        return ToDateNanos.fromDouble(value);
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field, Source source) {
            this.field = field;
            this.source = source;
        }

        public ToDateNanosFromDoubleEvaluator get(DriverContext context) {
            return new ToDateNanosFromDoubleEvaluator(this.field.get(context), this.source, context);
        }

        public String toString() {
            return "ToDateNanosFromDoubleEvaluator[field=" + String.valueOf(this.field) + "]";
        }
    }
}

