/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rank.feature;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.rank.feature.RankFeatureShardResult;

public class RankFeatureResult
extends SearchPhaseResult {
    private RankFeatureShardResult rankShardResult;

    public RankFeatureResult() {
    }

    public RankFeatureResult(ShardSearchContextId id, SearchShardTarget shardTarget, ShardSearchRequest request) {
        this.contextId = id;
        this.setSearchShardTarget(shardTarget);
        this.setShardSearchRequest(request);
    }

    public RankFeatureResult(StreamInput in) throws IOException {
        super(in);
        this.contextId = new ShardSearchContextId(in);
        this.rankShardResult = in.readOptionalWriteable(RankFeatureShardResult::new);
        this.setShardSearchRequest(in.readOptionalWriteable(ShardSearchRequest::new));
        this.setSearchShardTarget(in.readOptionalWriteable(SearchShardTarget::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        assert (this.hasReferences());
        this.contextId.writeTo(out);
        out.writeOptionalWriteable(this.rankShardResult);
        out.writeOptionalWriteable(this.getShardSearchRequest());
        out.writeOptionalWriteable(this.getSearchShardTarget());
    }

    @Override
    public RankFeatureResult rankFeatureResult() {
        return this;
    }

    public void shardResult(RankFeatureShardResult shardResult) {
        this.rankShardResult = shardResult;
    }

    public RankFeatureShardResult shardResult() {
        return this.rankShardResult;
    }

    @Override
    public boolean hasSearchContext() {
        return this.rankShardResult != null;
    }
}

