/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.info;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequestParameters;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.http.HttpStats;
import org.elasticsearch.ingest.IngestStats;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.script.ScriptStats;
import org.elasticsearch.threadpool.ThreadPoolStats;
import org.elasticsearch.xcontent.ToXContent;

@ServerlessScope(value=Scope.PUBLIC)
public class RestClusterInfoAction
extends BaseRestHandler {
    static final Map<NodesStatsRequestParameters.Metric, Function<NodesStatsResponse, ChunkedToXContent>> RESPONSE_MAPPER = Map.of(NodesStatsRequestParameters.Metric.HTTP, nodesStatsResponse -> nodesStatsResponse.getNodes().stream().map(NodeStats::getHttp).reduce(HttpStats.IDENTITY, HttpStats::merge), NodesStatsRequestParameters.Metric.INGEST, nodesStatsResponse -> nodesStatsResponse.getNodes().stream().map(NodeStats::getIngestStats).reduce(IngestStats.IDENTITY, IngestStats::merge), NodesStatsRequestParameters.Metric.THREAD_POOL, nodesStatsResponse -> nodesStatsResponse.getNodes().stream().map(NodeStats::getThreadPool).reduce(ThreadPoolStats.IDENTITY, ThreadPoolStats::merge), NodesStatsRequestParameters.Metric.SCRIPT, nodesStatsResponse -> nodesStatsResponse.getNodes().stream().map(NodeStats::getScriptStats).reduce(ScriptStats.IDENTITY, ScriptStats::merge));
    static final Set<NodesStatsRequestParameters.Metric> AVAILABLE_TARGETS = RESPONSE_MAPPER.keySet();
    static final Set<String> AVAILABLE_TARGET_NAMES = AVAILABLE_TARGETS.stream().map(NodesStatsRequestParameters.Metric::metricName).collect(Collectors.toUnmodifiableSet());

    @Override
    public String getName() {
        return "cluster_info_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_info/{target}"));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest().clear();
        nodesStatsRequest.setIncludeShardsStats(false);
        final Set<String> targets = Strings.tokenizeByCommaToSet(request.param("target"));
        if (targets.size() == 1 && targets.contains("_all")) {
            targets.clear();
            AVAILABLE_TARGETS.forEach(m -> {
                nodesStatsRequest.addMetric((NodesStatsRequestParameters.Metric)((Object)m));
                targets.add(m.metricName());
            });
        } else {
            if (targets.contains("_all")) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains _all and individual target [%s]", request.path(), request.param("target")));
            }
            TreeSet invalidTargetParams = targets.stream().filter(Predicate.not(AVAILABLE_TARGET_NAMES::contains)).collect(Collectors.toCollection(TreeSet::new));
            if (!invalidTargetParams.isEmpty()) {
                throw new IllegalArgumentException(RestClusterInfoAction.unrecognized(request, invalidTargetParams, AVAILABLE_TARGET_NAMES, "target"));
            }
            targets.forEach(metricName -> nodesStatsRequest.addMetric(NodesStatsRequestParameters.Metric.get(metricName)));
        }
        return channel -> new RestCancellableNodeClient(client, request.getHttpChannel()).admin().cluster().nodesStats(nodesStatsRequest, (ActionListener<NodesStatsResponse>)new RestResponseListener<NodesStatsResponse>(channel){

            @Override
            public RestResponse buildResponse(NodesStatsResponse response) throws Exception {
                Iterator chunkedResponses = targets.stream().map(NodesStatsRequestParameters.Metric::get).map(RESPONSE_MAPPER::get).map((? super T mapper) -> (ChunkedToXContent)mapper.apply(response)).iterator();
                return RestResponse.chunked(RestStatus.OK, ChunkedRestResponseBodyPart.fromXContent(outerParams -> Iterators.concat(ChunkedToXContentHelper.startObject(), Iterators.single((builder, params) -> builder.field("cluster_name", response.getClusterName().value())), Iterators.flatMap(chunkedResponses, chunk -> chunk.toXContentChunked(outerParams)), ChunkedToXContentHelper.endObject()), ToXContent.EMPTY_PARAMS, this.channel), null);
            }
        });
    }
}

